/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackChangesDialog
extends DialogWrapper {
    public static final String DELETE_LOCALLY_ADDED_FILES_KEY = "delete.locally.added.files";
    private final Project myProject;
    private final boolean myRefreshSynchronously;
    private final Runnable myAfterVcsRefreshInAwt;
    private final ChangesBrowser myBrowser;
    private final boolean myInvokedFromModalContext;
    private final JCheckBox myDeleteLocallyAddedFiles;
    private final ChangeInfoCalculator myInfoCalculator;
    private final CommitLegendPanel myCommitLegendPanel;
    private Runnable myListChangeListener;
    private String myOperationName;

    public static void rollbackChanges(Project project2, Collection<Change> changes) {
        RollbackChangesDialog.rollbackChanges(project2, changes, true, null);
    }

    public static void rollbackChanges(Project project2, Collection<Change> changes, boolean refreshSynchronously, Runnable afterVcsRefreshInAwt) {
        ChangeListManagerEx manager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project2);
        if (changes.isEmpty()) {
            RollbackChangesDialog.showNoChangesDialog(project2);
            return;
        }
        ArrayList<Change> validChanges = new ArrayList<Change>();
        THashSet lists = new THashSet();
        lists.addAll(manager.getInvolvedListsFilterChanges(changes, validChanges));
        new RollbackChangesDialog(project2, ContainerUtil.newArrayList((Iterable)lists), validChanges, refreshSynchronously, afterVcsRefreshInAwt).show();
    }

    public static void rollbackChanges(Project project2, LocalChangeList changeList) {
        ArrayList changes = new ArrayList(changeList.getChanges());
        if (changes.isEmpty()) {
            RollbackChangesDialog.showNoChangesDialog(project2);
            return;
        }
        new RollbackChangesDialog(project2, Collections.singletonList(changeList), Collections.emptyList(), true, null).show();
    }

    private static void showNoChangesDialog(Project project2) {
        String operationName = UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project2));
        Messages.showWarningDialog((Project)project2, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"changes.action.rollback.nothing", (Object[])new Object[]{operationName}));
    }

    public RollbackChangesDialog(Project project2, final List<LocalChangeList> changeLists, List<Change> changes, boolean refreshSynchronously, Runnable afterVcsRefreshInAwt) {
        super(project2, true);
        this.myProject = project2;
        this.myRefreshSynchronously = refreshSynchronously;
        this.myAfterVcsRefreshInAwt = afterVcsRefreshInAwt;
        this.myInvokedFromModalContext = LaterInvocator.isInModalContext();
        this.myInfoCalculator = new ChangeInfoCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator);
        this.myListChangeListener = new Runnable(){

            @Override
            public void run() {
                if (RollbackChangesDialog.this.myBrowser != null) {
                    List allChanges = RollbackChangesDialog.getAllChanges(changeLists);
                    Collection includedChanges = RollbackChangesDialog.this.myBrowser.getViewer().getIncludedChanges();
                    RollbackChangesDialog.this.myInfoCalculator.update(allChanges, ContainerUtil.newArrayList(includedChanges));
                    RollbackChangesDialog.this.myCommitLegendPanel.update();
                    boolean hasNewFiles = ContainerUtil.exists(includedChanges, (Condition)new Condition<Change>(){

                        public boolean value(Change change) {
                            return change.getType() == Change.Type.NEW;
                        }
                    });
                    RollbackChangesDialog.this.myDeleteLocallyAddedFiles.setEnabled(hasNewFiles);
                }
            }
        };
        this.myBrowser = new ChangesBrowser(project2, changeLists, changes, null, true, true, this.myListChangeListener, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null){

            @Override
            @NotNull
            protected DefaultTreeModel buildTreeModel(List<Change> changes, ChangeNodeDecorator changeNodeDecorator, boolean showFlatten) {
                DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChangeLists(this.myProject, showFlatten, changeLists);
                if (defaultTreeModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog$2", "buildTreeModel"));
                }
                return defaultTreeModel;
            }
        };
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myBrowser);
        this.myOperationName = RollbackChangesDialog.operationNameByChanges(project2, RollbackChangesDialog.getAllChanges(changeLists));
        this.setOKButtonText(this.myOperationName);
        this.myOperationName = UIUtil.removeMnemonic((String)this.myOperationName);
        this.setTitle(VcsBundle.message((String)"changes.action.rollback.custom.title", (Object[])new Object[]{this.myOperationName}));
        this.setCancelButtonText(CommonBundle.getCloseButtonText());
        this.myBrowser.setToggleActionTitle("&Include in " + this.myOperationName.toLowerCase());
        this.myDeleteLocallyAddedFiles = new JCheckBox(VcsBundle.message((String)"changes.checkbox.delete.locally.added.files", (Object[])new Object[0]));
        this.myDeleteLocallyAddedFiles.setSelected(PropertiesComponent.getInstance().isTrueValue(DELETE_LOCALLY_ADDED_FILES_KEY));
        this.myDeleteLocallyAddedFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PropertiesComponent.getInstance().setValue(RollbackChangesDialog.DELETE_LOCALLY_ADDED_FILES_KEY, RollbackChangesDialog.this.myDeleteLocallyAddedFiles.isSelected());
            }
        });
        this.init();
        this.myListChangeListener.run();
    }

    @NotNull
    public static String operationNameByChanges(@NotNull Project project2, @NotNull Collection<Change> changes) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog", "operationNameByChanges"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog", "operationNameByChanges"));
        }
        String string2 = RollbackUtil.getRollbackOperationName(ChangesUtil.getAffectedVcses(changes, (Project)project2));
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog", "operationNameByChanges"));
        }
        return string2;
    }

    @NotNull
    private static List<Change> getAllChanges(@NotNull List<? extends ChangeList> changeLists) {
        if (changeLists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeLists", "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog", "getAllChanges"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (ChangeList changeList : changeLists) {
            result2.addAll(changeList.getChanges());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/RollbackChangesDialog", "getAllChanges"));
        }
        return arrayList;
    }

    protected void doOKAction() {
        super.doOKAction();
        RollbackWorker worker = new RollbackWorker(this.myProject, this.myOperationName, this.myInvokedFromModalContext);
        worker.doRollback(this.myBrowser.getViewer().getIncludedChanges(), this.myDeleteLocallyAddedFiles.isSelected(), this.myAfterVcsRefreshInAwt, null);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gb2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
        gb2.fill = 2;
        gb2.weightx = 1.0;
        JPanel border = new JPanel(new BorderLayout());
        border.setBorder((Border)JBUI.Borders.emptyTop((int)2));
        border.add((Component)this.myBrowser, "Center");
        gb2.fill = 1;
        gb2.weighty = 1.0;
        ++gb2.gridy;
        panel2.add((Component)border, gb2);
        JComponent commitLegendPanel = this.myCommitLegendPanel.getComponent();
        commitLegendPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
        gb2.fill = 0;
        gb2.weightx = 0.0;
        gb2.weighty = 0.0;
        ++gb2.gridy;
        panel2.add((Component)commitLegendPanel, gb2);
        ++gb2.gridy;
        panel2.add((Component)this.myDeleteLocallyAddedFiles, gb2);
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBrowser.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "RollbackChangesDialog";
    }
}

