/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SessionDialog
extends DialogWrapper {
    @NonNls
    public static final String VCS_CONFIGURATION_UI_TITLE = "Vcs.SessionDialog.title";
    private final CommitSession mySession;
    private final List<Change> myChanges;
    private final String myCommitMessage;
    private final JPanel myCenterPanel = new JPanel(new BorderLayout());
    private final JComponent myConfigurationComponent;

    public SessionDialog(String title, Project project2, CommitSession session2, List<Change> changes, String commitMessage, @Nullable JComponent configurationComponent) {
        super(project2, true);
        this.mySession = session2;
        this.myChanges = changes;
        this.myCommitMessage = commitMessage;
        this.myConfigurationComponent = configurationComponent == null ? SessionDialog.createConfigurationUI(this.mySession, this.myChanges, this.myCommitMessage) : configurationComponent;
        String configurationComponentName = this.myConfigurationComponent != null ? (String)this.myConfigurationComponent.getClientProperty(VCS_CONFIGURATION_UI_TITLE) : null;
        this.setTitle(StringUtil.isEmptyOrSpaces((String)configurationComponentName) ? CommitChangeListDialog.trimEllipsis(title) : configurationComponentName);
        this.init();
        this.initValidation();
    }

    public SessionDialog(String title, Project project2, CommitSession session2, List<Change> changes, String commitMessage) {
        this(title, project2, session2, changes, commitMessage, null);
    }

    @Nullable
    public static JComponent createConfigurationUI(CommitSession session2, List<Change> changes, String commitMessage) {
        try {
            return session2.getAdditionalConfigurationUI(changes, commitMessage);
        }
        catch (AbstractMethodError e2) {
            return session2.getAdditionalConfigurationUI();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myCenterPanel.add((Component)this.myConfigurationComponent, "Center");
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myConfigurationComponent);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateButtons();
        return this.mySession.validateFields();
    }

    private void updateButtons() {
        this.setOKActionEnabled(this.mySession.canExecute(this.myChanges, this.myCommitMessage));
    }

    protected String getHelpId() {
        try {
            return this.mySession.getHelpId();
        }
        catch (AbstractMethodError e2) {
            return null;
        }
    }
}

