/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfigurableProvider;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.ui.IgnoredSettingsPanel;
import com.intellij.openapi.vcs.configurable.IssueNavigationConfigurationPanel;
import com.intellij.openapi.vcs.configurable.ShelfProjectConfigurable;
import com.intellij.openapi.vcs.configurable.VcsBackgroundOperationsConfigurable;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationConfigurable;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VcsManagerConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll {
    private final Project myProject;
    private VcsDirectoryConfigurationPanel myMappings;
    private VcsGeneralConfigurationConfigurable myGeneralPanel;

    public VcsManagerConfigurable(Project project2) {
        this.myProject = project2;
    }

    public JComponent createComponent() {
        this.myMappings = new VcsDirectoryConfigurationPanel(this.myProject);
        return this.myMappings;
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isModified() {
        return this.myMappings != null && this.myMappings.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myMappings.apply();
    }

    public void reset() {
        super.reset();
        this.myMappings.reset();
    }

    public boolean isVisible() {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcss().length > 0;
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        if (this.myMappings != null) {
            this.myMappings.disposeUIResources();
        }
        if (this.myGeneralPanel != null) {
            this.myGeneralPanel.disposeUIResources();
        }
        this.myMappings = null;
    }

    public String getDisplayName() {
        return VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Mappings";
    }

    @NotNull
    public String getId() {
        String string2 = VcsManagerConfigurable.getDefaultConfigurableIdValue((Configurable)this);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable", "getId"));
        }
        return string2;
    }

    @NotNull
    private static String getDefaultConfigurableIdValue(Configurable configurable) {
        String helpTopic = configurable.getHelpTopic();
        String string2 = helpTopic == null ? configurable.getClass().getName() : helpTopic;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable", "getDefaultConfigurableIdValue"));
        }
        return string2;
    }

    protected Configurable[] buildConfigurables() {
        VcsDescriptor[] vcses;
        this.myGeneralPanel = new VcsGeneralConfigurationConfigurable(this.myProject, this);
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.add(this.myGeneralPanel);
        result2.add(new VcsBackgroundOperationsConfigurable(this.myProject));
        if (!this.myProject.isDefault()) {
            result2.add(new IgnoredSettingsPanel(this.myProject));
        }
        result2.add(new IssueNavigationConfigurationPanel(this.myProject));
        if (!this.myProject.isDefault()) {
            result2.add(new ChangelistConflictConfigurable(ChangeListManagerImpl.getInstanceImpl(this.myProject)));
        }
        result2.add(new ShelfProjectConfigurable(this.myProject));
        for (VcsConfigurableProvider provider : (VcsConfigurableProvider[])VcsConfigurableProvider.EP_NAME.getExtensions()) {
            Configurable configurable = provider.getConfigurable(this.myProject);
            if (configurable == null) continue;
            result2.add(configurable);
        }
        for (VcsDescriptor vcs : vcses = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcss()) {
            result2.add(this.createVcsConfigurableWrapper(vcs));
        }
        return result2.toArray(new Configurable[result2.size()]);
    }

    public VcsDirectoryConfigurationPanel getMappings() {
        return this.myMappings;
    }

    private Configurable createVcsConfigurableWrapper(final VcsDescriptor vcs) {
        NotNullLazyValue<Configurable> delegate2 = new NotNullLazyValue<Configurable>(){

            @NotNull
            protected Configurable compute() {
                Configurable configurable = ProjectLevelVcsManager.getInstance((Project)VcsManagerConfigurable.this.myProject).findVcsByName(vcs.getName()).getConfigurable();
                if (configurable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable$1", "compute"));
                }
                return configurable;
            }
        };
        return new SearchableConfigurable((NotNullLazyValue)delegate2){
            final /* synthetic */ NotNullLazyValue val$delegate;
            {
                this.val$delegate = notNullLazyValue;
            }

            @Nls
            public String getDisplayName() {
                return vcs.getDisplayName();
            }

            public String getHelpTopic() {
                return ((Configurable)this.val$delegate.getValue()).getHelpTopic();
            }

            public JComponent createComponent() {
                return ((Configurable)this.val$delegate.getValue()).createComponent();
            }

            public boolean isModified() {
                return ((Configurable)this.val$delegate.getValue()).isModified();
            }

            public void apply() throws ConfigurationException {
                ((Configurable)this.val$delegate.getValue()).apply();
            }

            public void reset() {
                ((Configurable)this.val$delegate.getValue()).reset();
            }

            public void disposeUIResources() {
                ((Configurable)this.val$delegate.getValue()).disposeUIResources();
            }

            @NotNull
            public String getId() {
                String string2 = "vcs." + this.getDisplayName();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsManagerConfigurable$2", "getId"));
                }
                return string2;
            }

            public String toString() {
                return "VcsConfigurable for " + vcs.getDisplayName();
            }
        };
    }
}

