/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.configurable.VcsConfigurationsDialog;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.continuation.ModalityIgnorantBackgroundableTask;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class VcsMappingConfigurationDialog
extends DialogWrapper {
    private final Project myProject;
    private JComboBox myVCSComboBox;
    private TextFieldWithBrowseButton myDirectoryTextField;
    private JPanel myPanel;
    private JPanel myVcsConfigurablePlaceholder;
    private JRadioButton myProjectRadioButton;
    private JRadioButton myDirectoryRadioButton;
    private JBLabel myProjectButtonComment;
    private UnnamedConfigurable myVcsConfigurable;
    private VcsDirectoryMapping myMappingCopy;
    private JComponent myVcsConfigurableComponent;
    private ProjectLevelVcsManager myVcsManager;
    private final Map<String, VcsDescriptor> myVcses;

    public VcsMappingConfigurationDialog(Project project2, String title) {
        super(project2, false);
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VcsDescriptor[] vcsDescriptors = this.myVcsManager.getAllVcss();
        this.myVcses = new HashMap<String, VcsDescriptor>();
        for (VcsDescriptor vcsDescriptor : vcsDescriptors) {
            this.myVcses.put(vcsDescriptor.getName(), vcsDescriptor);
        }
        this.myVCSComboBox.setModel(VcsDirectoryConfigurationPanel.buildVcsWrappersModel(project2));
        this.myDirectoryTextField.addActionListener((ActionListener)((Object)new MyBrowseFolderListener("Select Directory", "Select directory to map to a VCS", this.myDirectoryTextField, project2, FileChooserDescriptorFactory.createSingleFolderDescriptor())));
        this.myMappingCopy = new VcsDirectoryMapping("", "");
        this.setTitle(title);
        this.init();
        this.myVCSComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VcsMappingConfigurationDialog.this.updateVcsConfigurable();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public void setMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog", "setMapping"));
        }
        this.myMappingCopy = new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings());
        this.myProjectRadioButton.setSelected(this.myMappingCopy.isDefaultMapping());
        this.myDirectoryRadioButton.setSelected(!this.myProjectRadioButton.isSelected());
        if (this.myMappingCopy.isDefaultMapping()) {
            this.myDirectoryTextField.setText("");
        } else {
            this.myDirectoryTextField.setText(FileUtil.toSystemDependentName((String)mapping.getDirectory()));
        }
        this.myVCSComboBox.setSelectedItem(this.myVcses.get(mapping.getVcs()));
        this.updateVcsConfigurable();
        this.myDirectoryTextField.setEnabled(this.myDirectoryRadioButton.isSelected());
        this.initProjectMessage();
    }

    @NotNull
    public VcsDirectoryMapping getMapping() {
        VcsDescriptor wrapper = (VcsDescriptor)this.myVCSComboBox.getSelectedItem();
        String vcs = wrapper == null || wrapper.isNone() ? "" : wrapper.getName();
        String directory = this.myProjectRadioButton.isSelected() ? "" : FileUtil.toSystemIndependentName((String)this.myDirectoryTextField.getText());
        VcsDirectoryMapping vcsDirectoryMapping = new VcsDirectoryMapping(directory, vcs, this.myMappingCopy.getRootSettings());
        if (vcsDirectoryMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog", "getMapping"));
        }
        return vcsDirectoryMapping;
    }

    private void updateVcsConfigurable() {
        UnnamedConfigurable configurable;
        AbstractVcs vcs;
        VcsDescriptor wrapper;
        if (this.myVcsConfigurable != null) {
            this.myVcsConfigurablePlaceholder.remove(this.myVcsConfigurableComponent);
            this.myVcsConfigurable.disposeUIResources();
            this.myVcsConfigurable = null;
        }
        if ((wrapper = (VcsDescriptor)this.myVCSComboBox.getSelectedItem()) != null && !wrapper.isNone() && (vcs = this.myVcsManager.findVcsByName(wrapper.getName())) != null && (configurable = vcs.getRootConfigurable(this.myMappingCopy)) != null) {
            this.myVcsConfigurable = configurable;
            this.myVcsConfigurableComponent = this.myVcsConfigurable.createComponent();
            this.myVcsConfigurablePlaceholder.add((Component)this.myVcsConfigurableComponent, "Center");
        }
        this.pack();
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{new ConfigureVcsAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    protected void doOKAction() {
        if (this.myVcsConfigurable != null) {
            try {
                this.myVcsConfigurable.apply();
            }
            catch (ConfigurationException ex) {
                Messages.showErrorDialog((Component)this.myPanel, (String)("Invalid VCS options: " + ex.getMessage()));
            }
        }
        super.doOKAction();
    }

    private void createUIComponents() {
        ButtonGroup bg = new ButtonGroup();
        this.myProjectRadioButton = new JRadioButton();
        this.myDirectoryRadioButton = new JRadioButton();
        bg.add(this.myProjectRadioButton);
        bg.add(this.myDirectoryRadioButton);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VcsMappingConfigurationDialog.this.myDirectoryTextField.setEnabled(VcsMappingConfigurationDialog.this.myDirectoryRadioButton.isSelected());
            }
        };
        this.myProjectRadioButton.addActionListener(al);
        this.myDirectoryRadioButton.addActionListener(al);
        this.myDirectoryRadioButton.setSelected(true);
    }

    public void initProjectMessage() {
        this.myProjectButtonComment.setText(XmlStringUtil.wrapInHtml((CharSequence)DefaultVcsRootPolicy.getInstance(this.myProject).getProjectConfigurationMessage(this.myProject)));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("VCS:");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myVCSComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myVcsConfigurablePlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JRadioButton jRadioButton = this.myProjectRadioButton;
        jRadioButton.setText("Project");
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton2 = this.myDirectoryRadioButton;
        jRadioButton2.setText("Directory:");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProjectButtonComment = jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("test");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 3));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class ConfigureVcsAction
    extends AbstractAction {
        public ConfigureVcsAction() {
            super(VcsBundle.message((String)"button.configure", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            VcsDescriptor wrapper = (VcsDescriptor)VcsMappingConfigurationDialog.this.myVCSComboBox.getSelectedItem();
            new VcsConfigurationsDialog(VcsMappingConfigurationDialog.this.myProject, null, wrapper).show();
        }
    }

    private class MyBrowseFolderListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> {
        public MyBrowseFolderListener(String title, String description, TextFieldWithBrowseButton textField, Project project2, FileChooserDescriptor fileChooserDescriptor2) {
            super(title, description, (ComponentWithBrowseButton)textField, project2, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        }

        protected VirtualFile getInitialFile() {
            VirtualFile file2;
            String text2 = this.getComponentText();
            if (text2.length() == 0 && (file2 = VcsMappingConfigurationDialog.this.myProject.getBaseDir()) != null) {
                return file2;
            }
            return super.getInitialFile();
        }

        protected void onFileChosen(final @NotNull VirtualFile chosenFile) {
            if (chosenFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$MyBrowseFolderListener", "onFileChosen"));
            }
            String oldText = VcsMappingConfigurationDialog.this.myDirectoryTextField.getText();
            super.onFileChosen(chosenFile);
            VcsDescriptor wrapper = (VcsDescriptor)VcsMappingConfigurationDialog.this.myVCSComboBox.getSelectedItem();
            if (oldText.length() == 0 && (wrapper == null || wrapper.isNone())) {
                ModalityIgnorantBackgroundableTask task2 = new ModalityIgnorantBackgroundableTask(VcsMappingConfigurationDialog.this.myProject, "Looking for VCS administrative area", false){
                    VcsDescriptor probableVcs;
                    {
                        super(project2, title, canBeCancelled);
                        this.probableVcs = null;
                    }

                    @Override
                    protected void doInAwtIfFail(@NotNull Exception e2) {
                        if (e2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$MyBrowseFolderListener$1", "doInAwtIfFail"));
                        }
                    }

                    @Override
                    protected void doInAwtIfCancel() {
                    }

                    @Override
                    protected void doInAwtIfSuccess() {
                        if (this.probableVcs != null) {
                            VcsMappingConfigurationDialog.this.myVCSComboBox.setSelectedItem(this.probableVcs);
                        }
                    }

                    @Override
                    protected void runImpl(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$MyBrowseFolderListener$1", "runImpl"));
                        }
                        for (VcsDescriptor vcs : VcsMappingConfigurationDialog.this.myVcses.values()) {
                            if (!vcs.probablyUnderVcs(chosenFile)) continue;
                            if (this.probableVcs != null) {
                                this.probableVcs = null;
                                break;
                            }
                            this.probableVcs = vcs;
                        }
                    }
                };
                ProgressManager.getInstance().run((Task)task2);
            }
        }
    }
}

