/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyLineStatusRangeAction
extends DumbAwareAction {
    private final LineStatusTrackerBase myLineStatusTracker;
    private final Range myRange;

    public CopyLineStatusRangeAction(@NotNull LineStatusTrackerBase lineStatusTracker, @NotNull Range range) {
        if (lineStatusTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineStatusTracker", "com/intellij/openapi/vcs/ex/CopyLineStatusRangeAction", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/CopyLineStatusRangeAction", "<init>"));
        }
        this.myLineStatusTracker = lineStatusTracker;
        this.myRange = range;
        ActionUtil.copyFrom((AnAction)this, (String)"$Copy");
    }

    public void update(AnActionEvent e2) {
        boolean enabled = 3 == this.myRange.getType() || 1 == this.myRange.getType();
        e2.getPresentation().setEnabled(this.myLineStatusTracker.isValid() && enabled);
    }

    public void actionPerformed(AnActionEvent e2) {
        String content2 = this.myLineStatusTracker.getVcsContent(this.myRange) + "\n";
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(content2));
    }
}

