/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vcs.actions.ShowNextChangeMarkerAction;
import com.intellij.openapi.vcs.actions.ShowPrevChangeMarkerAction;
import com.intellij.openapi.vcs.ex.CopyLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopup;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusRangeAction;
import com.intellij.openapi.vcs.ex.ShowLineStatusRangeDiffAction;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineStatusTrackerDrawing {
    private LineStatusTrackerDrawing() {
    }

    public static void moveToRange(Range range, Editor editor, LineStatusTracker tracker) {
        new MyLineStatusMarkerPopup(tracker, editor, range).scrollAndShow();
    }

    public static void showHint(Range range, Editor editor, LineStatusTracker tracker) {
        new MyLineStatusMarkerPopup(tracker, editor, range).showAfterScroll();
    }

    private static class ToggleByWordDiffAction
    extends LineStatusMarkerPopup.ToggleByWordDiffActionBase {
        @NotNull
        private final Range myRange;
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final LineStatusTracker myTracker;
        @Nullable
        private final Point myMousePosition;

        public ToggleByWordDiffAction(@NotNull Range range, @NotNull Editor editor, @NotNull LineStatusTracker tracker, @Nullable Point mousePosition) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$ToggleByWordDiffAction", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$ToggleByWordDiffAction", "<init>"));
            }
            if (tracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$ToggleByWordDiffAction", "<init>"));
            }
            this.myRange = range;
            this.myEditor = editor;
            this.myTracker = tracker;
            this.myMousePosition = mousePosition;
        }

        @Override
        protected void reshowPopup() {
            new MyLineStatusMarkerPopup(this.myTracker, this.myEditor, this.myRange).showHintAt(this.myMousePosition);
        }
    }

    public static class MyLineStatusMarkerPopup
    extends LineStatusMarkerPopup {
        @NotNull
        private final LineStatusTracker myTracker;

        public MyLineStatusMarkerPopup(@NotNull LineStatusTracker tracker, @NotNull Editor editor, @NotNull Range range) {
            if (tracker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "<init>"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "<init>"));
            }
            super(tracker, editor, range);
            this.myTracker = tracker;
        }

        @Override
        @NotNull
        protected List<AnAction> createToolbarActions(@Nullable Point mousePosition) {
            ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
            actions2.add((AnAction)new ShowPrevChangeMarkerAction(this.myTracker.getPrevRange(this.myRange), this.myTracker, this.myEditor));
            actions2.add((AnAction)new ShowNextChangeMarkerAction(this.myTracker.getNextRange(this.myRange), this.myTracker, this.myEditor));
            actions2.add((AnAction)new RollbackLineStatusRangeAction(this.myTracker, this.myRange, this.myEditor));
            actions2.add((AnAction)new ShowLineStatusRangeDiffAction(this.myTracker, this.myRange, this.myEditor));
            actions2.add((AnAction)new CopyLineStatusRangeAction(this.myTracker, this.myRange));
            actions2.add((AnAction)new ToggleByWordDiffAction(this.myRange, this.myEditor, this.myTracker, mousePosition));
            ArrayList<AnAction> arrayList = actions2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "createToolbarActions"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        protected FileType getFileType() {
            FileType fileType = this.myTracker.getVirtualFile().getFileType();
            if (fileType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/LineStatusTrackerDrawing$MyLineStatusMarkerPopup", "getFileType"));
            }
            return fileType;
        }
    }
}

