/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RangesBuilder {
    private static final Logger LOG = Logger.getInstance(RangesBuilder.class);

    @NotNull
    public static List<Range> createRanges(@NotNull Document current, @NotNull Document vcs) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        List<Range> list2 = RangesBuilder.createRanges(current, vcs, false);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        return list2;
    }

    @NotNull
    public static List<Range> createRanges(@NotNull Document current, @NotNull Document vcs, boolean innerWhitespaceChanges) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        List<Range> list2 = RangesBuilder.createRanges(DiffUtil.getLines(current), DiffUtil.getLines(vcs), 0, 0, innerWhitespaceChanges);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        return list2;
    }

    @NotNull
    public static List<Range> createRanges(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift, boolean innerWhitespaceChanges) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        if (innerWhitespaceChanges) {
            List<Range> list2 = RangesBuilder.createRangesSmart(current, vcs, currentShift, vcsShift);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
            }
            return list2;
        }
        List<Range> list3 = RangesBuilder.createRangesSimple(current, vcs, currentShift, vcsShift);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        return list3;
    }

    @NotNull
    private static List<Range> createRangesSimple(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRangesSimple"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRangesSimple"));
        }
        FairDiffIterable iterable = ByLine.compare(vcs, current, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        ArrayList<Range> result2 = new ArrayList<Range>();
        for (com.intellij.diff.util.Range range : iterable.iterateChanges()) {
            int vcsLine1 = vcsShift + range.start1;
            int vcsLine2 = vcsShift + range.end1;
            int currentLine1 = currentShift + range.start2;
            int currentLine2 = currentShift + range.end2;
            result2.add(new Range(currentLine1, currentLine2, vcsLine1, vcsLine2));
        }
        ArrayList<Range> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRangesSimple"));
        }
        return arrayList;
    }

    @NotNull
    private static List<Range> createRangesSmart(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRangesSmart"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRangesSmart"));
        }
        FairDiffIterable iwIterable = ByLine.compare(vcs, current, ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        RangeBuilder rangeBuilder = new RangeBuilder(current, vcs, currentShift, vcsShift);
        for (com.intellij.diff.util.Range range : iwIterable.iterateUnchanged()) {
            int count = range.end1 - range.start1;
            for (int i2 = 0; i2 < count; ++i2) {
                int vcsIndex = range.start1 + i2;
                int currentIndex = range.start2 + i2;
                if (!vcs.get(vcsIndex).equals(current.get(currentIndex))) continue;
                rangeBuilder.markEqual(vcsIndex, currentIndex);
            }
        }
        List<Range> list2 = rangeBuilder.finish();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRangesSmart"));
        }
        return list2;
    }

    private static byte getChangeType(int vcsStart, int vcsEnd, int currentStart, int currentEnd) {
        int deleted = vcsEnd - vcsStart;
        int inserted = currentEnd - currentStart;
        if (deleted > 0 && inserted > 0) {
            return 1;
        }
        if (deleted > 0) {
            return 3;
        }
        if (inserted > 0) {
            return 2;
        }
        LOG.error("Unknown change type");
        return 0;
    }

    private static class RangeBuilder
    extends DiffIterableUtil.ChangeBuilderBase {
        @NotNull
        private final List<String> myCurrent;
        @NotNull
        private final List<String> myVcs;
        private final int myCurrentShift;
        private final int myVcsShift;
        @NotNull
        private final List<Range> myResult;

        public RangeBuilder(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift) {
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder$RangeBuilder", "<init>"));
            }
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder$RangeBuilder", "<init>"));
            }
            super(vcs.size(), current.size());
            this.myResult = new ArrayList<Range>();
            this.myCurrent = current;
            this.myVcs = vcs;
            this.myCurrentShift = currentShift;
            this.myVcsShift = vcsShift;
        }

        @NotNull
        public List<Range> finish() {
            this.doFinish();
            List<Range> list2 = this.myResult;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder$RangeBuilder", "finish"));
            }
            return list2;
        }

        @Override
        protected void addChange(int vcsStart, int currentStart, int vcsEnd, int currentEnd) {
            com.intellij.diff.util.Range range = TrimUtil.expand(this.myVcs, this.myCurrent, vcsStart, currentStart, vcsEnd, currentEnd);
            if (range.isEmpty()) {
                return;
            }
            List<Range.InnerRange> innerRanges = this.calcInnerRanges(range);
            Range newRange = new Range(range.start2, range.end2, range.start1, range.end1, innerRanges);
            newRange.shift(this.myCurrentShift);
            newRange.vcsShift(this.myVcsShift);
            this.myResult.add(newRange);
        }

        @NotNull
        private List<Range.InnerRange> calcInnerRanges(@NotNull com.intellij.diff.util.Range blockRange) {
            if (blockRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockRange", "com/intellij/openapi/vcs/ex/RangesBuilder$RangeBuilder", "calcInnerRanges"));
            }
            List<String> vcs = this.myVcs.subList(blockRange.start1, blockRange.end1);
            List<String> current = this.myCurrent.subList(blockRange.start2, blockRange.end2);
            ArrayList<Range.InnerRange> result2 = new ArrayList<Range.InnerRange>();
            FairDiffIterable iwIterable = ByLine.compare(vcs, current, ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
            for (Pair<com.intellij.diff.util.Range, Boolean> pair : DiffIterableUtil.iterateAll(iwIterable)) {
                com.intellij.diff.util.Range range = (com.intellij.diff.util.Range)pair.first;
                Boolean equals = (Boolean)pair.second;
                byte type = equals != false ? (byte)0 : RangesBuilder.getChangeType(range.start1, range.end1, range.start2, range.end2);
                result2.add(new Range.InnerRange(range.start2 + blockRange.start2, range.end2 + blockRange.start2, type));
            }
            result2.trimToSize();
            ArrayList<Range.InnerRange> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder$RangeBuilder", "calcInnerRanges"));
            }
            return arrayList;
        }
    }
}

