/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowLineStatusRangeDiffAction
extends DumbAwareAction {
    private final LineStatusTrackerBase myLineStatusTracker;
    private final Range myRange;

    public ShowLineStatusRangeDiffAction(@NotNull LineStatusTrackerBase lineStatusTracker, @NotNull Range range, @Nullable Editor editor) {
        if (lineStatusTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineStatusTracker", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "<init>"));
        }
        this.myLineStatusTracker = lineStatusTracker;
        this.myRange = range;
        ActionUtil.copyFrom((AnAction)this, (String)"ChangesView.Diff");
    }

    public void update(AnActionEvent e2) {
        e2.getPresentation().setEnabled(this.myLineStatusTracker.isValid());
    }

    public void actionPerformed(AnActionEvent e2) {
        DiffManager.getInstance().showDiff(e2.getProject(), this.createDiffData());
    }

    @NotNull
    private DiffRequest createDiffData() {
        Range range = ShowLineStatusRangeDiffAction.expand(this.myRange, this.myLineStatusTracker.getDocument(), this.myLineStatusTracker.getVcsDocument());
        DiffContent vcsContent = this.createDiffContent(this.myLineStatusTracker.getVcsDocument(), this.myLineStatusTracker.getVcsTextRange(range));
        DiffContent currentContent = this.createDiffContent(this.myLineStatusTracker.getDocument(), this.myLineStatusTracker.getCurrentTextRange(range));
        SimpleDiffRequest simpleDiffRequest = new SimpleDiffRequest(VcsBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, currentContent, VcsBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), VcsBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0]));
        if (simpleDiffRequest == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "createDiffData"));
        }
        return simpleDiffRequest;
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull Document document, @NotNull TextRange textRange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "createDiffContent"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "createDiffContent"));
        }
        Project project2 = this.myLineStatusTracker.getProject();
        DocumentContent content2 = DiffContentFactory.getInstance().create(project2, document);
        DocumentContent documentContent = DiffContentFactory.getInstance().createFragment(project2, content2, textRange);
        if (documentContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "createDiffContent"));
        }
        return documentContent;
    }

    @NotNull
    private static Range expand(@NotNull Range range, @NotNull Document document, @NotNull Document uDocument) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
        }
        if (uDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uDocument", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
        }
        boolean canExpandBefore = range.getLine1() != 0 && range.getVcsLine1() != 0;
        boolean canExpandAfter = range.getLine2() < document.getLineCount() && range.getVcsLine2() < uDocument.getLineCount();
        int offset1 = range.getLine1() - (canExpandBefore ? 1 : 0);
        int uOffset1 = range.getVcsLine1() - (canExpandBefore ? 1 : 0);
        int offset2 = range.getLine2() + (canExpandAfter ? 1 : 0);
        int uOffset2 = range.getVcsLine2() + (canExpandAfter ? 1 : 0);
        Range range2 = new Range(offset1, offset2, uOffset1, uOffset2);
        if (range2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/ShowLineStatusRangeDiffAction", "expand"));
        }
        return range2;
    }
}

