/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyRevisionNumberAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "actionPerformed"));
        }
        List revisions = CopyRevisionNumberAction.getRevisionNumbersFromContext(e2);
        revisions = ContainerUtil.reverse(revisions);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyRevisionNumberAction.getHashesAsString(revisions)));
    }

    @NotNull
    private static List<VcsRevisionNumber> getRevisionNumbersFromContext(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getRevisionNumbersFromContext"));
        }
        VcsRevisionNumber[] revisionNumbers = (VcsRevisionNumber[])e2.getData(VcsDataKeys.VCS_REVISION_NUMBERS);
        List<Object> list2 = revisionNumbers != null ? Arrays.asList(revisionNumbers) : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getRevisionNumbersFromContext"));
        }
        return list2;
    }

    @NotNull
    private static String getHashesAsString(@NotNull List<VcsRevisionNumber> revisions) {
        if (revisions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisions", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getHashesAsString"));
        }
        String string2 = StringUtil.join(revisions, (Function)new Function<VcsRevisionNumber, String>(){

            public String fun(VcsRevisionNumber revision) {
                return revision.asString();
            }
        }, (String)" ");
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "getHashesAsString"));
        }
        return string2;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/CopyRevisionNumberAction", "update"));
        }
        super.update(e2);
        e2.getPresentation().setEnabled(!CopyRevisionNumberAction.getRevisionNumbersFromContext(e2).isEmpty());
    }
}

