/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ShowDiffWithLocalAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/ShowDiffWithLocalAction", "actionPerformed"));
        }
        Project project2 = (Project)e2.getRequiredData(CommonDataKeys.PROJECT);
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(null)) {
            return;
        }
        VcsRevisionNumber currentRevisionNumber = ((VcsHistorySession)e2.getRequiredData(VcsDataKeys.HISTORY_SESSION)).getCurrentRevisionNumber();
        VcsFileRevision selectedRevision = ((VcsFileRevision[])e2.getRequiredData(VcsDataKeys.VCS_FILE_REVISIONS))[0];
        FilePath filePath = (FilePath)e2.getRequiredData(VcsDataKeys.FILE_PATH);
        if (currentRevisionNumber != null && selectedRevision != null) {
            DiffFromHistoryHandler diffHandler = (DiffFromHistoryHandler)ObjectUtils.notNull((Object)((VcsHistoryProvider)e2.getRequiredData(VcsDataKeys.HISTORY_PROVIDER)).getHistoryDiffHandler(), (Object)new StandardDiffFromHistoryHandler());
            diffHandler.showDiffForTwo(project2, filePath, selectedRevision, (VcsFileRevision)new CurrentRevision(filePath.getVirtualFile(), currentRevisionNumber));
        }
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/history/ShowDiffWithLocalAction", "update"));
        }
        VcsFileRevision[] selectedRevisions = (VcsFileRevision[])e2.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        VirtualFile virtualFile = (VirtualFile)e2.getData(CommonDataKeys.VIRTUAL_FILE);
        VcsHistorySession historySession = (VcsHistorySession)e2.getData(VcsDataKeys.HISTORY_SESSION);
        e2.getPresentation().setVisible(true);
        e2.getPresentation().setEnabled(selectedRevisions != null && selectedRevisions.length == 1 && virtualFile != null && historySession != null && historySession.getCurrentRevisionNumber() != null && historySession.isContentAvailable(selectedRevisions[0]) && e2.getData(VcsDataKeys.FILE_PATH) != null && e2.getData(VcsDataKeys.HISTORY_PROVIDER) != null && e2.getData(CommonDataKeys.PROJECT) != null);
    }
}

