/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    private final Project myProject;
    private final VirtualFile myBaseDir;

    public BasicDefaultVcsRootPolicy(Project project2) {
        this.myProject = project2;
        this.myBaseDir = project2.getBaseDir();
    }

    @Override
    @NotNull
    public List<VirtualFile> getDefaultVcsRoots(@NotNull NewMappings mappingList, @NotNull String vcsName) {
        if (mappingList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappingList", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "getDefaultVcsRoots"));
        }
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "getDefaultVcsRoots"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        VirtualFile baseDir = ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
        if (baseDir != null && vcsName.equals(mappingList.getVcsFor(baseDir))) {
            result2.add(baseDir);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "getDefaultVcsRoots"));
        }
        return arrayList;
    }

    @Override
    public boolean matchesDefaultMapping(@NotNull VirtualFile file2, Object matchContext) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "matchesDefaultMapping"));
        }
        return VfsUtil.isAncestor((VirtualFile)ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir), (VirtualFile)file2, (boolean)false);
    }

    @Override
    @Nullable
    public Object getMatchContext(VirtualFile file2) {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "getVcsRootFor"));
        }
        return ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getDirtyRoots() {
        List<VirtualFile> list2 = Collections.singletonList(ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/BasicDefaultVcsRootPolicy", "getDirtyRoots"));
        }
        return list2;
    }
}

