/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ModuleVcsDetector
implements ProjectComponent {
    private final Project myProject;
    private final MessageBus myMessageBus;
    private final ProjectLevelVcsManagerImpl myVcsManager;
    private MessageBusConnection myConnection;

    public ModuleVcsDetector(Project project2, MessageBus messageBus, ProjectLevelVcsManager vcsManager) {
        this.myProject = project2;
        this.myMessageBus = messageBus;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)vcsManager;
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager manager = StartupManager.getInstance((Project)this.myProject);
        manager.registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                if (ModuleVcsDetector.this.myVcsManager.needAutodetectMappings()) {
                    ModuleVcsDetector.this.autoDetectVcsMappings(true);
                }
                ModuleVcsDetector.this.myVcsManager.updateActiveVcss();
            }
        });
        manager.registerPostStartupActivity(new Runnable(){

            @Override
            public void run() {
                if (ModuleVcsDetector.this.myMessageBus != null) {
                    ModuleVcsDetector.this.myConnection = ModuleVcsDetector.this.myMessageBus.connect();
                    MyModulesListener listener2 = new MyModulesListener();
                    ModuleVcsDetector.this.myConnection.subscribe(ProjectTopics.MODULES, (Object)listener2);
                    ModuleVcsDetector.this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
                }
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ModuleVcsDetector" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/ModuleVcsDetector", "getComponentName"));
        }
        return "ModuleVcsDetector";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
        }
    }

    private void autoDetectVcsMappings(boolean tryMapPieces) {
        HashSet<AbstractVcs> usedVcses = new HashSet<AbstractVcs>();
        HashMap<VirtualFile, AbstractVcs> vcsMap = new HashMap<VirtualFile, AbstractVcs>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module2 : moduleManager.getModules()) {
            VirtualFile[] files2;
            for (VirtualFile file2 : files2 = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
                AbstractVcs contentRootVcs = this.myVcsManager.findVersioningVcs(file2);
                if (contentRootVcs != null) {
                    vcsMap.put(file2, contentRootVcs);
                }
                usedVcses.add(contentRootVcs);
            }
        }
        if (usedVcses.size() == 1) {
            AbstractVcs[] abstractVcses = usedVcses.toArray(new AbstractVcs[1]);
            Module[] moduleArray = moduleManager.getModules();
            HashSet<String> contentRoots = new HashSet<String>();
            for (Module module3 : moduleArray) {
                VirtualFile[] roots;
                for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module3).getContentRoots()) {
                    contentRoots.add(root.getPath());
                }
            }
            if (abstractVcses[0] != null) {
                ArrayList<VcsDirectoryMapping> arrayList = new ArrayList<VcsDirectoryMapping>(this.myVcsManager.getDirectoryMappings());
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    VcsDirectoryMapping mapping = (VcsDirectoryMapping)iterator2.next();
                    if (contentRoots.contains(mapping.getDirectory())) continue;
                    iterator2.remove();
                }
                this.myVcsManager.setAutoDirectoryMapping("", abstractVcses[0].getName());
                for (VcsDirectoryMapping mapping : arrayList) {
                    this.myVcsManager.removeDirectoryMapping(mapping);
                }
                this.myVcsManager.cleanupMappings();
            }
        } else if (tryMapPieces) {
            for (Map.Entry entry : vcsMap.entrySet()) {
                this.myVcsManager.setAutoDirectoryMapping(((VirtualFile)entry.getKey()).getPath(), entry.getValue() == null ? "" : ((AbstractVcs)entry.getValue()).getName());
            }
            this.myVcsManager.cleanupMappings();
        }
    }

    private void autoDetectModuleVcsMapping(Module module2) {
        VirtualFile[] files2;
        boolean mappingsUpdated = false;
        for (VirtualFile file2 : files2 = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            AbstractVcs vcs = this.myVcsManager.findVersioningVcs(file2);
            if (vcs == null || vcs == this.myVcsManager.getVcsFor(file2)) continue;
            this.myVcsManager.setAutoDirectoryMapping(file2.getPath(), vcs.getName());
            mappingsUpdated = true;
        }
        if (mappingsUpdated) {
            this.myVcsManager.cleanupMappings();
        }
    }

    private List<Pair<String, VcsDirectoryMapping>> getMappings(Module module2) {
        ArrayList<Pair<String, VcsDirectoryMapping>> result2 = new ArrayList<Pair<String, VcsDirectoryMapping>>();
        VirtualFile[] files2 = ModuleRootManager.getInstance((Module)module2).getContentRoots();
        String moduleName = module2.getName();
        block0: for (VirtualFile file2 : files2) {
            for (VcsDirectoryMapping mapping : this.myVcsManager.getDirectoryMappings()) {
                if (!FileUtil.toSystemIndependentName((String)mapping.getDirectory()).equals(file2.getPath())) continue;
                result2.add((Pair<String, VcsDirectoryMapping>)Pair.create((Object)moduleName, (Object)mapping));
                continue block0;
            }
        }
        return result2;
    }

    private class MyModulesListener
    implements ModuleRootListener,
    ModuleListener {
        private final List<Pair<String, VcsDirectoryMapping>> myMappingsForRemovedModules = new ArrayList<Pair<String, VcsDirectoryMapping>>();

        private MyModulesListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
            this.myMappingsForRemovedModules.clear();
        }

        public void rootsChanged(ModuleRootEvent event) {
            for (Pair<String, VcsDirectoryMapping> mapping : this.myMappingsForRemovedModules) {
                ModuleVcsDetector.this.myVcsManager.removeDirectoryMapping((VcsDirectoryMapping)mapping.second);
            }
            if (ModuleVcsDetector.this.myVcsManager.needAutodetectMappings()) {
                ModuleVcsDetector.this.autoDetectVcsMappings(false);
            }
        }

        public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener", "moduleAdded"));
            }
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener", "moduleAdded"));
            }
            this.myMappingsForRemovedModules.removeAll(ModuleVcsDetector.this.getMappings(module2));
            ModuleVcsDetector.this.autoDetectModuleVcsMapping(module2);
        }

        public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener", "beforeModuleRemoved"));
            }
            if (module2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener", "beforeModuleRemoved"));
            }
            this.myMappingsForRemovedModules.addAll(ModuleVcsDetector.this.getMappings(module2));
        }
    }
}

