/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import org.jetbrains.annotations.Nullable;

public class UpToDateLineNumberProviderImpl
implements UpToDateLineNumberProvider {
    private final Document myDocument;
    private final LineStatusTrackerManagerI myLineStatusTrackerManagerI;

    public UpToDateLineNumberProviderImpl(Document document, Project project2) {
        this.myDocument = document;
        this.myLineStatusTrackerManagerI = LineStatusTrackerManager.getInstance(project2);
    }

    public boolean isRangeChanged(int start2, int end) {
        LineStatusTracker tracker = this.getTracker();
        if (tracker == null) {
            return false;
        }
        return tracker.isRangeModified(start2, end);
    }

    public boolean isLineChanged(int currentNumber) {
        LineStatusTracker tracker = this.getTracker();
        if (tracker == null) {
            return false;
        }
        return tracker.isLineModified(currentNumber);
    }

    public int getLineNumber(int currentNumber) {
        LineStatusTracker tracker = this.getTracker();
        if (tracker == null) {
            return currentNumber;
        }
        return tracker.transferLineToVcs(currentNumber, false);
    }

    public int getLineCount() {
        LineStatusTracker tracker = this.getTracker();
        if (tracker == null) {
            return this.myDocument.getLineCount();
        }
        return tracker.getVcsDocument().getLineCount();
    }

    @Nullable
    private LineStatusTracker getTracker() {
        LineStatusTracker tracker = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        return tracker != null && tracker.isOperational() ? tracker : null;
    }
}

