/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsEP
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsEP");
    public static final ExtensionPointName<VcsEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.vcs");
    @Attribute(value="name")
    public String name;
    @Attribute(value="vcsClass")
    public String vcsClass;
    @Attribute(value="displayName")
    public String displayName;
    @Attribute(value="administrativeAreaName")
    public String administrativeAreaName;
    @Attribute(value="crawlUpToCheckUnderVcs")
    public boolean crawlUpToCheckUnderVcs;
    private AbstractVcs myVcs;
    private final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcs(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsEP", "getVcs"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myVcs != null) {
                return this.myVcs;
            }
        }
        AbstractVcs vcs = this.getInstance(project2, this.vcsClass);
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (this.myVcs == null && vcs != null) {
                vcs.setupEnvironments();
                this.myVcs = vcs;
            }
            return this.myVcs;
        }
    }

    @Nullable
    private AbstractVcs getInstance(@NotNull Project project2, @NotNull String vcsClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsEP", "getInstance"));
        }
        if (vcsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsClass", "com/intellij/openapi/vcs/impl/VcsEP", "getInstance"));
        }
        try {
            Class<?>[] interfaces;
            Class foundClass = this.findClass(vcsClass);
            for (Class<?> anInterface : interfaces = foundClass.getInterfaces()) {
                if (!BaseComponent.class.isAssignableFrom(anInterface)) continue;
                return (AbstractVcs)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, foundClass);
            }
            return (AbstractVcs)this.instantiate(vcsClass, project2.getPicoContainer());
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
            return null;
        }
    }

    @NotNull
    public VcsDescriptor createDescriptor() {
        VcsDescriptor vcsDescriptor = new VcsDescriptor(this.administrativeAreaName, this.displayName, this.name, this.crawlUpToCheckUnderVcs);
        if (vcsDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/VcsEP", "createDescriptor"));
        }
        return vcsDescriptor;
    }
}

