/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.StandardProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.util.TimeoutUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class VcsInitialization
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.VcsInitialization");
    private final List<Pair<VcsInitObject, Runnable>> myList;
    private final Object myLock;
    @NotNull
    private final Project myProject;
    private Status myStatus;
    private volatile Future<?> myFuture;
    private final ProgressIndicator myIndicator;

    VcsInitialization(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsInitialization", "<init>"));
        }
        this.myList = new ArrayList<Pair<VcsInitObject, Runnable>>();
        this.myStatus = Status.IDLE;
        this.myIndicator = new StandardProgressIndicatorBase();
        this.myProject = project2;
        this.myLock = new Object();
        StartupManager.getInstance((Project)project2).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsInitialization", "lambda$new$0"));
            }
            if (project2.isDisposed()) {
                return;
            }
            this.myFuture = ((ProgressManagerImpl)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(new Task.Backgroundable(this.myProject, "VCS Initialization"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/VcsInitialization$1", "run"));
                    }
                    VcsInitialization.this.execute(indicator);
                }
            }, this.myIndicator, null);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull VcsInitObject vcsInitObject, @NotNull Runnable runnable2) {
        if (vcsInitObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsInitObject", "com/intellij/openapi/vcs/impl/VcsInitialization", "add"));
        }
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/vcs/impl/VcsInitialization", "add"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myStatus != Status.IDLE) {
                if (!vcsInitObject.isCanBeLast()) {
                    LOG.info("Registering startup activity AFTER initialization ", new Throwable());
                }
                ApplicationManager.getApplication().invokeLater(runnable2, this.myProject.getDisposed());
                return;
            }
            this.myList.add((Pair<VcsInitObject, Runnable>)Pair.create((Object)((Object)vcsInitObject), (Object)runnable2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void execute(@NotNull ProgressIndicator indicator) {
        List<Pair<VcsInitObject, Runnable>> list2;
        block18: {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/impl/VcsInitialization", "execute"));
            }
            Iterator<Pair<VcsInitObject, Runnable>> iterator2 = this.myLock;
            // MONITORENTER : iterator2
            list2 = this.myList;
            if (this.myStatus == Status.IDLE) break block18;
            // MONITOREXIT : iterator2
            Object object = this.myLock;
            // MONITORENTER : object
            this.myStatus = Status.FINISHED;
            // MONITOREXIT : object
            return;
        }
        this.myStatus = Status.RUNNING;
        Future<?> future2 = this.myFuture;
        if (future2 != null && future2.isCancelled() || indicator.isCanceled()) {
            // MONITOREXIT : iterator2
            Object object = this.myLock;
            // MONITORENTER : object
            this.myStatus = Status.FINISHED;
            // MONITOREXIT : object
            return;
        }
        try {
            // MONITOREXIT : iterator2
            Collections.sort(list2, Comparator.comparingInt(o2 -> ((VcsInitObject)((Object)((Object)o2.getFirst()))).getOrder()));
            for (Pair<VcsInitObject, Runnable> pair : list2) {
                ProgressManager.checkCanceled();
                ((Runnable)pair.getSecond()).run();
            }
            Object object = this.myLock;
        }
        catch (Throwable throwable) {
            Object object = this.myLock;
            // MONITORENTER : object
            this.myStatus = Status.FINISHED;
            // MONITOREXIT : object
            throw throwable;
        }
        this.myStatus = Status.FINISHED;
        // MONITOREXIT : object
    }

    public void dispose() {
        this.myIndicator.cancel();
        this.cancelBackgroundInitialization();
    }

    private void cancelBackgroundInitialization() {
        Future<?> future2 = this.myFuture;
        LOG.debug("cancelBackgroundInitialization() future=" + future2 + " from " + Thread.currentThread() + " with write access=" + ApplicationManager.getApplication().isWriteAccessAllowed());
        if (future2 != null) {
            future2.cancel(false);
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                SwingUtilities.invokeLater(this::waitForCompletion);
            } else {
                this.waitForCompletion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion() {
        LOG.debug("waitForCompletion() status=" + (Object)((Object)this.myStatus));
        long start2 = System.currentTimeMillis();
        Status status = null;
        while (System.currentTimeMillis() < start2 + 10000L) {
            Object object = this.myLock;
            synchronized (object) {
                status = this.myStatus;
                if (status != Status.RUNNING) {
                    break;
                }
            }
            TimeoutUtil.sleep((long)10L);
        }
        if (status == Status.RUNNING) {
            LOG.error("Failed to wait for completion of VCS initialization for project " + this.myProject, new Attachment[]{new Attachment("thread dump", ThreadDumper.dumpThreadsToString())});
        }
    }

    private static enum Status {
        IDLE,
        RUNNING,
        FINISHED;

    }
}

