/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.MonospaceEditorCustomization;
import com.intellij.ui.RightMarginEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.WrapWhenTypingReachesRightMarginCustomization;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable,
DataProvider,
CommitMessageI {
    public static final Key<CommitMessage> DATA_KEY = Key.create((String)"Vcs.CommitMessage.Panel");
    private final EditorTextField myEditorField;
    private final TitledSeparator mySeparator;
    @NotNull
    private List<ChangeList> myChangeLists;

    public CommitMessage(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "<init>"));
        }
        this(project2, true);
    }

    public CommitMessage(@NotNull Project project2, @NotNull CommitMessage commitMessage) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "<init>"));
        }
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/ui/CommitMessage", "<init>"));
        }
        this(project2);
        this.myEditorField.setDocument(commitMessage.getEditorField().getDocument());
    }

    public CommitMessage(@NotNull Project project2, boolean withSeparator) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "<init>"));
        }
        super(new BorderLayout());
        this.myChangeLists = Collections.emptyList();
        this.myEditorField = CommitMessage.createCommitTextEditor(project2, false);
        this.myEditorField.getDocument().putUserData(DATA_KEY, (Object)this);
        this.add((Component)((Object)this.myEditorField), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", CommitMessage.getToolbarActions(), withSeparator);
        toolbar.updateActionsImmediately();
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent());
            JPanel separatorPanel = new JPanel(new BorderLayout());
            separatorPanel.add((Component)this.mySeparator, "South");
            separatorPanel.add(Box.createVerticalGlue(), "North");
            JPanel labelPanel = new JPanel(new BorderLayout());
            labelPanel.setBorder(BorderFactory.createEmptyBorder());
            labelPanel.add((Component)separatorPanel, "Center");
            labelPanel.add((Component)toolbar.getComponent(), "East");
            this.add((Component)labelPanel, "North");
        } else {
            this.mySeparator = null;
            this.add((Component)toolbar.getComponent(), "East");
        }
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setSeparatorText(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vcs/ui/CommitMessage", "setSeparatorText"));
        }
        if (this.mySeparator != null) {
            this.mySeparator.setText(text2);
        }
    }

    public void setCommitMessage(String currentDescription) {
        this.setText(currentDescription);
    }

    public static EditorTextField createCommitTextEditor(@NotNull Project project2, boolean forceSpellCheckOn) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/ui/CommitMessage", "createCommitTextEditor"));
        }
        HashSet<EditorCustomization> features = new HashSet<EditorCustomization>();
        VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project2);
        if (configuration != null) {
            boolean enableSpellChecking = forceSpellCheckOn || configuration.CHECK_COMMIT_MESSAGE_SPELLING;
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getCustomization(enableSpellChecking));
            features.add(new RightMarginEditorCustomization(configuration.USE_COMMIT_MESSAGE_MARGIN, configuration.COMMIT_MESSAGE_MARGIN_SIZE));
            features.add(WrapWhenTypingReachesRightMarginCustomization.getInstance(configuration.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN));
        } else {
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
            features.add(new RightMarginEditorCustomization(false, -1));
        }
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        features.add(MonospaceEditorCustomization.getInstance());
        EditorTextFieldProvider service = (EditorTextFieldProvider)ServiceManager.getService((Project)project2, EditorTextFieldProvider.class);
        return service.getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project2, features);
    }

    @NotNull
    private static ActionGroup getToolbarActions() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
        if (actionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getToolbarActions"));
        }
        return actionGroup;
    }

    @NotNull
    public EditorTextField getEditorField() {
        EditorTextField editorTextField = this.myEditorField;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getEditorField"));
        }
        return editorTextField;
    }

    public void setText(@Nullable String initialMessage) {
        String text2 = initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage);
        this.myEditorField.setText(text2);
    }

    @NotNull
    public String getComment() {
        String s2 = this.myEditorField.getDocument().getCharsSequence().toString();
        String string2 = StringUtil.trimTrailing((String)s2);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getComment"));
        }
        return string2;
    }

    public void requestFocusInMessage() {
        this.myEditorField.requestFocus();
        this.myEditorField.selectAll();
    }

    public void dispose() {
    }

    public void setChangeLists(@NotNull List<ChangeList> value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/ui/CommitMessage", "setChangeLists"));
        }
        WriteAction.run(() -> {
            if (value2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/ui/CommitMessage", "lambda$setChangeLists$0"));
            }
            this.myChangeLists = value2;
        });
    }

    @NotNull
    public List<ChangeList> getChangeLists() {
        List<ChangeList> list2 = this.myChangeLists;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/CommitMessage", "getChangeLists"));
        }
        return list2;
    }
}

