/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;

public class FontUtil {
    @NotNull
    public static Font getFontAbleToDisplay(char c2, int size, int style, @NotNull String family) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/openapi/vcs/ui/FontUtil", "getFontAbleToDisplay"));
        }
        Font font = ComplementaryFontsRegistry.getFontAbleToDisplay(c2, size, style, family, null).getFont();
        if (font == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getFontAbleToDisplay"));
        }
        return font;
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        Font font = UIUtil.getLabelFont();
        String string2 = FontUtil.getHtmlWithFonts(input, font.getStyle(), font);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        return string2;
    }

    @NotNull
    public static String getHtmlWithFonts(@NotNull String input, int style, @NotNull Font baseFont) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        if (baseFont == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFont", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        int start2 = baseFont.canDisplayUpTo(input);
        if (start2 == -1) {
            String string2 = input;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
            }
            return string2;
        }
        Font font = null;
        StringBuilder result2 = new StringBuilder(input.substring(0, start2));
        for (int i2 = start2; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (baseFont.canDisplay(c2)) {
                if (font != null) {
                    result2.append("</font>");
                }
                result2.append(c2);
                font = null;
                continue;
            }
            if (font != null && font.canDisplay(c2)) {
                result2.append(c2);
                continue;
            }
            if (font != null) {
                result2.append("</font>");
            }
            if ((font = FontUtil.getFontAbleToDisplay(c2, baseFont.getSize(), style, baseFont.getFamily())) != baseFont) {
                result2.append("<font face=\"").append(font.getFamily()).append("\">");
            }
            result2.append(c2);
        }
        if (font != null) {
            result2.append("</font>");
        }
        String string3 = result2.toString();
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ui/FontUtil", "getHtmlWithFonts"));
        }
        return string3;
    }
}

