/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectReloadState;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.UpdateInfo;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RestoreUpdateTree", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RestoreUpdateTree
implements ProjectComponent,
PersistentStateComponent<Element> {
    private final Project myProject;
    private UpdateInfo myUpdateInfo;

    public RestoreUpdateTree(Project project2) {
        this.myProject = project2;
    }

    public static RestoreUpdateTree getInstance(Project project2) {
        return (RestoreUpdateTree)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, RestoreUpdateTree.class);
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ActionInfo actionInfo;
                if (RestoreUpdateTree.this.myUpdateInfo != null && !RestoreUpdateTree.this.myUpdateInfo.isEmpty() && ProjectReloadState.getInstance((Project)RestoreUpdateTree.this.myProject).isAfterAutomaticReload() && (actionInfo = RestoreUpdateTree.this.myUpdateInfo.getActionInfo()) != null) {
                    ProjectLevelVcsManagerEx.getInstanceEx(RestoreUpdateTree.this.myProject).showUpdateProjectInfo(RestoreUpdateTree.this.myUpdateInfo.getFileInformation(), VcsBundle.message((String)"action.display.name.update", (Object[])new Object[0]), actionInfo, false);
                    CommittedChangesCache.getInstance(RestoreUpdateTree.this.myProject).refreshIncomingChangesAsync();
                }
                RestoreUpdateTree.this.myUpdateInfo = null;
            }
        });
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("RestoreUpdateTree" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/RestoreUpdateTree", "getComponentName"));
        }
        return "RestoreUpdateTree";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        if (this.myUpdateInfo != null && !this.myUpdateInfo.isEmpty()) {
            try {
                this.myUpdateInfo.writeExternal(element);
            }
            catch (WriteExternalException e2) {
                throw new RuntimeException(e2);
            }
        }
        return element;
    }

    public void loadState(Element state) {
        UpdateInfo updateInfo = new UpdateInfo();
        try {
            updateInfo.readExternal(state);
        }
        catch (InvalidDataException e2) {
            throw new RuntimeException(e2);
        }
        this.myUpdateInfo = updateInfo.isEmpty() ? null : updateInfo;
    }

    public void registerUpdateInformation(UpdatedFiles updatedFiles, ActionInfo actionInfo) {
        this.myUpdateInfo = new UpdateInfo(updatedFiles, actionInfo);
    }
}

