/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeGoToChangePopupAction;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e2) {
        DataContext dc2 = e2.getDataContext();
        Presentation presentation = e2.getPresentation();
        presentation.setEnabled(this.isVisible(dc2) && this.isEnabled(dc2));
    }

    private boolean isVisible(DataContext dc2) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc2);
        return project2 != null && VcsDataKeys.LABEL_BEFORE.getData(dc2) != null && VcsDataKeys.LABEL_AFTER.getData(dc2) != null;
    }

    private boolean isEnabled(DataContext dc2) {
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc2);
        return iterable != null;
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext dc2 = e2.getDataContext();
        if (!this.isVisible(dc2) || !this.isEnabled(dc2)) {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dc2);
        Iterable iterable = (Iterable)e2.getRequiredData(VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE);
        Label before = (Label)e2.getRequiredData(VcsDataKeys.LABEL_BEFORE);
        Label after2 = (Label)e2.getRequiredData(VcsDataKeys.LABEL_AFTER);
        String selectedUrl = (String)VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.getData(dc2);
        MyDiffRequestChain requestChain = new MyDiffRequestChain(project2, iterable, before, after2, selectedUrl);
        DiffManager.getInstance().showDiff(project2, (DiffRequestChain)requestChain, DiffDialogHints.FRAME);
    }

    private static class MyDiffRequestChain
    extends UserDataHolderBase
    implements DiffRequestChain,
    GoToChangePopupBuilder.Chain {
        @Nullable
        private final Project myProject;
        @NotNull
        private final Label myBefore;
        @NotNull
        private final Label myAfter;
        @NotNull
        private final List<MyDiffRequestProducer> myRequests;
        private int myIndex;

        public MyDiffRequestChain(@Nullable Project project2, @NotNull Iterable<Pair<VirtualFilePointer, FileStatus>> iterable, @NotNull Label before, @NotNull Label after2, @Nullable String selectedUrl) {
            if (iterable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterable", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "<init>"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "<init>"));
            }
            if (after2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "<init>"));
            }
            this.myRequests = new ArrayList<MyDiffRequestProducer>();
            this.myProject = project2;
            this.myBefore = before;
            this.myAfter = after2;
            int selected = -1;
            for (Pair<VirtualFilePointer, FileStatus> pair : iterable) {
                if (selected == -1 && ((VirtualFilePointer)pair.first).getUrl().equals(selectedUrl)) {
                    selected = this.myRequests.size();
                }
                this.myRequests.add(new MyDiffRequestProducer((VirtualFilePointer)pair.first, (FileStatus)pair.second));
            }
            if (selected != -1) {
                this.myIndex = selected;
            }
        }

        @NotNull
        public List<MyDiffRequestProducer> getRequests() {
            List<MyDiffRequestProducer> list2 = this.myRequests;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "getRequests"));
            }
            return list2;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public void setIndex(int index) {
            this.myIndex = index;
        }

        @Override
        @NotNull
        public AnAction createGoToChangeAction(@NotNull Consumer<Integer> onSelected) {
            if (onSelected == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSelected", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "createGoToChangeAction"));
            }
            ChangeGoToChangePopupAction.Fake<MyDiffRequestChain> fake = new ChangeGoToChangePopupAction.Fake<MyDiffRequestChain>(this, this.myIndex, onSelected){

                @Override
                @NotNull
                protected FilePath getFilePath(int index) {
                    FilePath filePath = ((MyDiffRequestProducer)myRequests.get(index)).getFilePath();
                    if (filePath == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$1", "getFilePath"));
                    }
                    return filePath;
                }

                @Override
                @NotNull
                protected FileStatus getFileStatus(int index) {
                    FileStatus fileStatus = ((MyDiffRequestProducer)myRequests.get(index)).getFileStatus();
                    if (fileStatus == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$1", "getFileStatus"));
                    }
                    return fileStatus;
                }
            };
            if (fake == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "createGoToChangeAction"));
            }
            return fake;
        }

        @NotNull
        private static byte[] loadContent(@NotNull VirtualFilePointer filePointer, @NotNull Label label) throws DiffRequestProducerException {
            if (filePointer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointer", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "loadContent"));
            }
            if (label == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "loadContent"));
            }
            String path = filePointer.getPresentableUrl();
            ByteContent byteContent = label.getByteContent(FileUtil.toSystemIndependentName((String)path));
            if (byteContent == null || byteContent.isDirectory() || byteContent.getBytes() == null) {
                throw new DiffRequestProducerException("Can't load content");
            }
            byte[] byArray = byteContent.getBytes();
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain", "loadContent"));
            }
            return byArray;
        }

        private class MyDiffRequestProducer
        implements DiffRequestProducer {
            @NotNull
            private final VirtualFilePointer myFilePointer;
            @NotNull
            private final FileStatus myFileStatus;
            @NotNull
            private final FilePath myFilePath;

            public MyDiffRequestProducer(@NotNull VirtualFilePointer filePointer, FileStatus fileStatus) {
                if (filePointer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointer", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "<init>"));
                }
                if (fileStatus == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatus", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "<init>"));
                }
                this.myFilePointer = filePointer;
                this.myFileStatus = fileStatus;
                this.myFilePath = VcsUtil.getFilePath((String)this.myFilePointer.getPresentableUrl(), (boolean)false);
            }

            @NotNull
            public String getName() {
                String string2 = this.myFilePointer.getUrl();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "getName"));
                }
                return string2;
            }

            @NotNull
            public FilePath getFilePath() {
                FilePath filePath = this.myFilePath;
                if (filePath == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "getFilePath"));
                }
                return filePath;
            }

            @NotNull
            public FileStatus getFileStatus() {
                FileStatus fileStatus = this.myFileStatus;
                if (fileStatus == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "getFileStatus"));
                }
                return fileStatus;
            }

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context2, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                SimpleDiffRequest simpleDiffRequest;
                block8: {
                    if (context2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "process"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "process"));
                    }
                    try {
                        EmptyContent content2;
                        EmptyContent content1;
                        DiffContentFactoryEx contentFactory = DiffContentFactoryEx.getInstanceEx();
                        if (FileStatus.ADDED.equals(this.myFileStatus)) {
                            content1 = contentFactory.createEmpty();
                        } else {
                            byte[] bytes1 = MyDiffRequestChain.loadContent(this.myFilePointer, MyDiffRequestChain.this.myBefore);
                            content1 = contentFactory.createFromBytes(MyDiffRequestChain.this.myProject, bytes1, this.myFilePath);
                        }
                        if (FileStatus.DELETED.equals(this.myFileStatus)) {
                            content2 = contentFactory.createEmpty();
                        } else {
                            byte[] bytes2 = MyDiffRequestChain.loadContent(this.myFilePointer, MyDiffRequestChain.this.myAfter);
                            content2 = contentFactory.createFromBytes(MyDiffRequestChain.this.myProject, bytes2, this.myFilePath);
                        }
                        String title = DiffRequestFactoryImpl.getContentTitle(this.myFilePath);
                        simpleDiffRequest = new SimpleDiffRequest(title, (DiffContent)content1, (DiffContent)content2, "Before update", "After update");
                        if (simpleDiffRequest != null) break block8;
                    }
                    catch (IOException e2) {
                        throw new DiffRequestProducerException("Can't load content", (Throwable)e2);
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyDiffRequestChain$MyDiffRequestProducer", "process"));
                }
                return simpleDiffRequest;
            }
        }
    }
}

