/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import java.util.List;

public class UpdateFilesHelper {
    private UpdateFilesHelper() {
    }

    public static void iterateFileGroupFilesDeletedOnServerFirst(UpdatedFiles updatedFiles, Callback callback) {
        FileGroup changedOnServer = updatedFiles.getGroupById("CHANGED_ON_SERVER");
        if (changedOnServer != null) {
            List children2 = changedOnServer.getChildren();
            for (FileGroup child : children2) {
                if (!"REMOVED_FROM_REPOSITORY".equals(child.getId())) continue;
                UpdateFilesHelper.iterateGroup(child, callback);
            }
        }
        List groups2 = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups2) {
            UpdateFilesHelper.iterateGroup(group, callback);
            for (FileGroup childGroup : group.getChildren()) {
                if ("REMOVED_FROM_REPOSITORY".equals(childGroup.getId())) continue;
                UpdateFilesHelper.iterateGroup(childGroup, callback);
            }
        }
    }

    private static void iterateGroup(FileGroup group, Callback callback) {
        for (String file2 : group.getFiles()) {
            callback.onFile(file2, group.getId());
        }
    }

    public static void iterateFileGroupFiles(UpdatedFiles updatedFiles, Callback callback) {
        List groups2 = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups2) {
            UpdateFilesHelper.iterateGroup(group, callback);
            for (FileGroup childGroup : group.getChildren()) {
                UpdateFilesHelper.iterateGroup(childGroup, callback);
            }
        }
    }

    private static void iterateGroup(FileGroup group, Consumer<Couple<String>> callback) {
        for (FileGroup.UpdatedFile updatedFile : group.getUpdatedFiles()) {
            callback.consume((Object)Couple.of((Object)updatedFile.getPath(), (Object)updatedFile.getVcsName()));
        }
    }

    public static void iterateAffectedFiles(UpdatedFiles updatedFiles, Consumer<Couple<String>> callback) {
        List groups2 = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups2) {
            UpdateFilesHelper.iterateGroup(group, callback);
            for (FileGroup childGroup : group.getChildren()) {
                UpdateFilesHelper.iterateGroup(childGroup, callback);
            }
        }
    }

    public static interface Callback {
        public void onFile(String var1, String var2);
    }
}

