/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.Function;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseFileEncodingAction
extends ComboBoxAction {
    private final VirtualFile myVirtualFile;
    public static final Charset NO_ENCODING = new Charset("NO_ENCODING", null){

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    public ChooseFileEncodingAction(@Nullable VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
    }

    public abstract void update(AnActionEvent var1);

    private void fillCharsetActions(@NotNull DefaultActionGroup group, final @Nullable VirtualFile virtualFile, @NotNull List<Charset> charsets, @NotNull Function<Charset, String> charsetFilter) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction", "fillCharsetActions"));
        }
        if (charsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charsets", "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction", "fillCharsetActions"));
        }
        if (charsetFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charsetFilter", "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction", "fillCharsetActions"));
        }
        for (final Charset charset : charsets) {
            String description = (String)charsetFilter.fun((Object)charset);
            DumbAwareAction action2 = new DumbAwareAction(charset.displayName(), description, description == null ? AllIcons.General.Warning : null){

                public void actionPerformed(AnActionEvent e2) {
                    ChooseFileEncodingAction.this.chosen(virtualFile, charset);
                }
            };
            group.add((AnAction)action2);
        }
    }

    protected abstract void chosen(@Nullable VirtualFile var1, @NotNull Charset var2);

    @NotNull
    protected DefaultActionGroup createCharsetsActionGroup(@Nullable String clearItemText, @Nullable Charset alreadySelected, @NotNull Function<Charset, String> charsetFilter) {
        if (charsetFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charsetFilter", "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction", "createCharsetsActionGroup"));
        }
        DefaultActionGroup group = new DefaultActionGroup();
        ArrayList<Charset> favorites = new ArrayList<Charset>(EncodingManager.getInstance().getFavorites());
        Collections.sort(favorites);
        Charset current = this.myVirtualFile == null ? null : this.myVirtualFile.getCharset();
        favorites.remove(current);
        favorites.remove(alreadySelected);
        if (clearItemText != null) {
            String description = "Clear " + (this.myVirtualFile == null ? "default" : "file '" + this.myVirtualFile.getName() + "'") + " encoding.";
            group.add((AnAction)new DumbAwareAction(clearItemText, description, null){

                public void actionPerformed(AnActionEvent e2) {
                    ChooseFileEncodingAction.this.chosen(ChooseFileEncodingAction.this.myVirtualFile, NO_ENCODING);
                }
            });
        }
        if (favorites.isEmpty() && clearItemText == null) {
            this.fillCharsetActions(group, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        } else {
            this.fillCharsetActions(group, this.myVirtualFile, favorites, charsetFilter);
            DefaultActionGroup more = new DefaultActionGroup("more", true);
            group.add((AnAction)more);
            this.fillCharsetActions(more, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), charsetFilter);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction", "createCharsetsActionGroup"));
        }
        return defaultActionGroup;
    }
}

