/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingUtil {
    private static final String REASON_FILE_IS_A_DIRECTORY = "directory";
    private static final String REASON_BINARY_FILE = "binary";
    private static final String REASON_HARDCODED_IN_TEXT = "hard-coded";
    private static final String REASON_HARDCODED_FOR_FILE = "%s";

    static Magic8 isSafeToReloadIn(@NotNull VirtualFile virtualFile, @NotNull String text2, @NotNull byte[] bytes, @NotNull Charset charset) {
        byte[] bytesToSave;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToReloadIn"));
        }
        byte[] bom = virtualFile.getBOM();
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)charset, (byte[])bom)) {
            return Magic8.NO_WAY;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)charset);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            return Magic8.NO_WAY;
        }
        String loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, charset).toString();
        String separator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        String toSave = StringUtil.convertLineSeparators((String)loaded, (String)separator);
        String failReason = LoadTextUtil.wasCharsetDetectedFromBytes(virtualFile);
        if (failReason != null && CharsetToolkit.UTF8_CHARSET.equals(virtualFile.getCharset()) && !CharsetToolkit.UTF8_CHARSET.equals(charset)) {
            return Magic8.NO_WAY;
        }
        try {
            bytesToSave = toSave.getBytes(charset);
        }
        catch (UnsupportedOperationException e2) {
            return Magic8.NO_WAY;
        }
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        return !Arrays.equals(bytesToSave, bytes) ? Magic8.NO_WAY : (loaded.equals(text2) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
    }

    static Magic8 isSafeToConvertTo(@NotNull VirtualFile virtualFile, @NotNull String text2, @NotNull byte[] bytesOnDisk, @NotNull Charset charset) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        if (bytesOnDisk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytesOnDisk", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "isSafeToConvertTo"));
        }
        try {
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
            String textToSave = lineSeparator.equals("\n") ? text2 : StringUtil.convertLineSeparators((String)text2, (String)lineSeparator);
            Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(virtualFile.getCharset(), charset, textToSave);
            byte[] saved = (byte[])chosen.second;
            CharSequence textLoadedBack = LoadTextUtil.getTextByBinaryPresentation(saved, charset);
            return !text2.equals(textLoadedBack.toString()) ? Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e2) {
            return Magic8.NO_WAY;
        }
    }

    static void saveIn(@NotNull Document document, Editor editor, @NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        boolean writable;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vfs/encoding/EncodingUtil", "saveIn"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "saveIn"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "saveIn"));
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        documentManager.saveDocument(document);
        Project project2 = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        boolean bl = writable = project2 == null ? virtualFile.isWritable() : ReadonlyStatusHandler.ensureFilesWritable((Project)project2, (VirtualFile[])new VirtualFile[]{virtualFile});
        if (!writable) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)("Cannot save the file " + virtualFile.getPresentableUrl()), (String)"Unable to Save", null);
            return;
        }
        EncodingProjectManagerImpl.suppressReloadDuring(() -> {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "lambda$saveIn$1"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "lambda$saveIn$1"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vfs/encoding/EncodingUtil", "lambda$saveIn$1"));
            }
            EncodingManager.getInstance().setEncoding(virtualFile, charset);
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (virtualFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "lambda$null$0"));
                    }
                    if (charset == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "lambda$null$0"));
                    }
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vfs/encoding/EncodingUtil", "lambda$null$0"));
                    }
                    virtualFile.setCharset(charset);
                    LoadTextUtil.write(project2, virtualFile, virtualFile, document.getText(), document.getModificationStamp());
                    return null;
                });
            }
            catch (IOException io) {
                Messages.showErrorDialog((Project)project2, (String)io.getMessage(), (String)"Error Writing File");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reloadIn(final @NotNull VirtualFile virtualFile, final @NotNull Charset charset) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "reloadIn"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/encoding/EncodingUtil", "reloadIn"));
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.getCachedDocument(virtualFile) == null) {
            EncodingManager.getInstance().setEncoding(virtualFile, charset);
            return;
        }
        final Disposable disposable = Disposer.newDisposable();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(disposable);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void beforeFileContentReload(VirtualFile file2, @NotNull Document document) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/vfs/encoding/EncodingUtil$1", "beforeFileContentReload"));
                }
                if (!file2.equals(virtualFile)) {
                    return;
                }
                Disposer.dispose((Disposable)disposable);
                EncodingManager.getInstance().setEncoding(file2, charset);
                LoadTextUtil.setCharsetWasDetectedFromBytes(file2, null);
            }
        });
        try {
            EncodingProjectManagerImpl.suppressReloadDuring(() -> {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "lambda$reloadIn$2"));
                }
                ((VirtualFileListener)documentManager).contentsChanged(new VirtualFileEvent(null, virtualFile, virtualFile.getName(), virtualFile.getParent()));
            });
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    private static String checkHardcodedCharsetFileType(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkHardcodedCharsetFileType"));
        }
        FileType fileType = virtualFile.getFileType();
        if (fileType == FileTypes.PLAIN_TEXT) {
            return null;
        }
        if (fileType == StdFileTypes.GUI_DESIGNER_FORM) {
            return "IDEA GUI Designer form";
        }
        if (fileType == StdFileTypes.IDEA_MODULE) {
            return "IDEA module file";
        }
        if (fileType == StdFileTypes.IDEA_PROJECT) {
            return "IDEA project file";
        }
        if (fileType == StdFileTypes.IDEA_WORKSPACE) {
            return "IDEA workspace file";
        }
        if (fileType == StdFileTypes.PROPERTIES) {
            return ".properties file\n(see Settings|Editor|File Encodings|Properties Files)";
        }
        if (fileType == StdFileTypes.XML) {
            return "XML file";
        }
        if (fileType == StdFileTypes.JSPX) {
            return "JSPX file";
        }
        return null;
    }

    @NotNull
    public static Pair<Charset, String> checkCanReload(@NotNull VirtualFile virtualFile) {
        String failReason;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
        }
        if (virtualFile.isDirectory()) {
            Pair pair = Pair.create(null, (Object)REASON_FILE_IS_A_DIRECTORY);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
            }
            return pair;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(virtualFile);
        if (document == null) {
            Pair pair = Pair.create(null, (Object)REASON_BINARY_FILE);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
            }
            return pair;
        }
        Charset charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        Charset existing = virtualFile.getCharset();
        String autoDetectedFrom = LoadTextUtil.wasCharsetDetectedFromBytes(virtualFile);
        if (autoDetectedFrom != null) {
            failReason = "the encoding was " + autoDetectedFrom;
        } else if (charsetFromContent != null) {
            failReason = REASON_HARDCODED_IN_TEXT;
            existing = charsetFromContent;
        } else {
            failReason = EncodingUtil.fileTypeDescriptionError(virtualFile);
        }
        Pair pair = Pair.create((Object)existing, (Object)failReason);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanReload"));
        }
        return pair;
    }

    @Nullable
    private static String fileTypeDescriptionError(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "fileTypeDescriptionError"));
        }
        if (virtualFile.getFileType().isBinary()) {
            return REASON_BINARY_FILE;
        }
        String fileTypeDescription = EncodingUtil.checkHardcodedCharsetFileType(virtualFile);
        return fileTypeDescription == null ? null : String.format(REASON_HARDCODED_FOR_FILE, fileTypeDescription);
    }

    @Nullable(value="null means enabled, notnull means disabled and contains error message")
    static String checkCanConvert(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkCanConvert"));
        }
        if (virtualFile.isDirectory()) {
            return REASON_FILE_IS_A_DIRECTORY;
        }
        Charset charsetFromContent = ((EncodingManagerImpl)EncodingManager.getInstance()).computeCharsetFromContent(virtualFile);
        return charsetFromContent != null ? REASON_HARDCODED_IN_TEXT : EncodingUtil.fileTypeDescriptionError(virtualFile);
    }

    @Nullable
    public static Pair<Charset, String> checkSomeActionEnabled(@NotNull VirtualFile selectedFile) {
        if (selectedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFile", "com/intellij/openapi/vfs/encoding/EncodingUtil", "checkSomeActionEnabled"));
        }
        String saveError = EncodingUtil.checkCanConvert(selectedFile);
        if (saveError == null) {
            return null;
        }
        Pair<Charset, String> reloadResult = EncodingUtil.checkCanReload(selectedFile);
        String reloadError = (String)reloadResult.second;
        if (reloadError == null) {
            return null;
        }
        String errorDescription = saveError.equals(reloadError) ? saveError : saveError + ", " + reloadError;
        return Pair.create((Object)reloadResult.first, (Object)errorDescription);
    }

    static enum Magic8 {
        ABSOLUTELY,
        WELL_IF_YOU_INSIST,
        NO_WAY;

    }
}

