/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DummyCachingFileSystem<T extends VirtualFile>
extends DummyFileSystem {
    private final String myProtocol;
    private final FactoryMap<String, T> myCachedFiles = new ConcurrentFactoryMap<String, T>(){

        protected T create(String key) {
            return DummyCachingFileSystem.this.findFileByPathInner(key);
        }

        public T get(Object key) {
            VirtualFile file2 = (VirtualFile)super.get(key);
            if (file2 != null && !file2.isValid()) {
                this.remove(key);
                return (VirtualFile)super.get(key);
            }
            return file2;
        }
    };
    private static final Key<Boolean> DISPOSE_CALLBACK = Key.create((String)"DISPOSE_CALLBACK");

    public DummyCachingFileSystem(String protocol2) {
        this.myProtocol = protocol2;
        Application application = ApplicationManager.getApplication();
        application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerAdapter(){

            public void projectOpened(Project project2) {
                DummyCachingFileSystem.this.onProjectOpened(project2);
            }

            public void projectClosed(Project project2) {
                DummyCachingFileSystem.this.registerDisposeCallback(project2);
            }
        });
        this.initProjectMap();
    }

    @Override
    @NotNull
    public final String getProtocol() {
        String string2 = this.myProtocol;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "getProtocol"));
        }
        return string2;
    }

    @Override
    @Nullable
    public final VirtualFile createRoot(String name) {
        return null;
    }

    public final T findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "findFileByPath"));
        }
        return (T)((VirtualFile)this.myCachedFiles.get((Object)path));
    }

    @Override
    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "extractPresentableUrl"));
        }
        T file2 = this.findFileByPath(path);
        String string2 = file2 != null ? this.getPresentableUrl((VirtualFile)file2) : super.extractPresentableUrl(path);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "extractPresentableUrl"));
        }
        return string2;
    }

    protected String getPresentableUrl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "getPresentableUrl"));
        }
        return file2.getPresentableName();
    }

    protected abstract T findFileByPathInner(@NotNull String var1);

    protected void doRenameFile(VirtualFile vFile, String newName) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Nullable
    public Project getProject(@Nullable String projectId) {
        Project project2 = ((ProjectManagerImpl)ProjectManager.getInstance()).findOpenProjectByHash(projectId);
        if (ApplicationManager.getApplication().isUnitTestMode() && project2 != null) {
            this.registerDisposeCallback(project2);
            DISPOSE_CALLBACK.set((UserDataHolder)project2, (Object)Boolean.TRUE);
        }
        return project2;
    }

    @NotNull
    public Project getProjectOrFail(String projectId) {
        Project project2 = this.getProject(projectId);
        if (project2 == null) {
            throw new AssertionError((Object)String.format("'%s' project not found among %s", projectId, StringUtil.join((Object[])ProjectManager.getInstance().getOpenProjects(), p2 -> p2.getLocationHash(), (String)", ")));
        }
        Project project3 = project2;
        if (project3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "getProjectOrFail"));
        }
        return project3;
    }

    @NotNull
    public Collection<T> getCachedFiles() {
        Collection collection = this.myCachedFiles.notNullValues();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "getCachedFiles"));
        }
        return collection;
    }

    public void onProjectClosed(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "onProjectClosed"));
        }
        this.clearCache();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.cleanup();
        }
    }

    public void onProjectOpened(Project project2) {
        this.clearCache();
    }

    private void registerDisposeCallback(final Project project2) {
        if (Boolean.TRUE.equals(DISPOSE_CALLBACK.get((UserDataHolder)project2))) {
            return;
        }
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                DummyCachingFileSystem.this.onProjectClosed(project2);
            }
        });
    }

    private void initProjectMap() {
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isOpen()) continue;
            this.onProjectOpened(project2);
        }
    }

    protected void clearCache() {
        this.clearInvalidFiles();
    }

    protected void clearInvalidFiles() {
        for (VirtualFile t2 : this.myCachedFiles.notNullValues()) {
            if (t2.isValid()) continue;
            this.myCachedFiles.removeValue((Object)t2);
        }
        while (this.myCachedFiles.removeValue(null)) {
        }
    }

    private void cleanup() {
        this.myCachedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "renameFile"));
        }
        String oldName = vFile.getName();
        this.beforeFileRename(vFile, requestor, oldName, newName);
        try {
            this.doRenameFile(vFile, newName);
        }
        finally {
            this.fileRenamed(vFile, requestor, oldName, newName);
        }
    }

    protected void beforeFileRename(@NotNull VirtualFile file2, Object requestor, @NotNull String oldName, @NotNull String newName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "beforeFileRename"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "beforeFileRename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "beforeFileRename"));
        }
        this.fireBeforePropertyChange(requestor, file2, "name", oldName, newName);
        this.myCachedFiles.remove((Object)file2.getPath());
    }

    protected void fileRenamed(@NotNull VirtualFile file2, Object requestor, String oldName, String newName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/ex/dummy/DummyCachingFileSystem", "fileRenamed"));
        }
        this.myCachedFiles.put((Object)file2.getPath(), (Object)file2);
        this.firePropertyChanged(requestor, file2, "name", oldName, newName);
    }

    protected static String escapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"/", (String)"&slash;");
    }

    protected static String unescapeSlash(String name) {
        return name == null ? "" : StringUtil.replace((String)name, (String)"&slash;", (String)"/");
    }
}

