/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.dummy;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.ex.dummy.DummyFileIdGenerator;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.ex.dummy.VirtualFileDirectoryImpl;
import org.jetbrains.annotations.NotNull;

abstract class VirtualFileImpl
extends VirtualFile
implements VirtualFileWithId {
    private final DummyFileSystem myFileSystem;
    private final VirtualFileDirectoryImpl myParent;
    private String myName;
    protected boolean myIsValid = true;
    private final int myId = DummyFileIdGenerator.next();

    protected VirtualFileImpl(DummyFileSystem fileSystem, VirtualFileDirectoryImpl parent, String name) {
        this.myFileSystem = fileSystem;
        this.myParent = parent;
        this.myName = name;
    }

    public int getId() {
        return this.myId;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        DummyFileSystem dummyFileSystem = this.myFileSystem;
        if (dummyFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/VirtualFileImpl", "getFileSystem"));
        }
        return dummyFileSystem;
    }

    @NotNull
    public String getPath() {
        if (this.myParent == null) {
            String string2 = this.myName;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/VirtualFileImpl", "getPath"));
            }
            return string2;
        }
        String string3 = this.myParent.getPath() + "/" + this.myName;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/VirtualFileImpl", "getPath"));
        }
        return string3;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/ex/dummy/VirtualFileImpl", "getName"));
        }
        return string2;
    }

    void setName(String name) {
        this.myName = name;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }
}

