/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import org.jetbrains.annotations.NotNull;

class IdentityVirtualFilePointer
extends VirtualFilePointerImpl
implements VirtualFilePointer,
Disposable {
    private final VirtualFile myFile;
    private final String myUrl;
    private volatile int useCount;

    IdentityVirtualFilePointer(VirtualFile file2, @NotNull String url, VirtualFilePointerListener listener2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "<init>"));
        }
        super(listener2);
        this.myFile = file2;
        this.myUrl = url;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string2 = this.getUrl();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "getFileName"));
        }
        return string2;
    }

    @Override
    public VirtualFile getFile() {
        return this.isValid() ? this.myFile : null;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string2 = this.myUrl;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "getUrl"));
        }
        return string2;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String string2 = this.getUrl();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/IdentityVirtualFilePointer", "getPresentableUrl"));
        }
        return string2;
    }

    @Override
    public boolean isValid() {
        return this.myFile == null || this.myFile.isValid();
    }

    @Override
    int incrementUsageCount(int delta) {
        return this.useCount += delta;
    }

    @Override
    public void dispose() {
        this.incrementUsageCount(-1);
    }
}

