/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightFilePointer
implements VirtualFilePointer {
    private final String myUrl;
    private VirtualFile myFile;

    public LightFilePointer(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/LightFilePointer", "<init>"));
        }
        this.myUrl = url;
    }

    public LightFilePointer(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/LightFilePointer", "<init>"));
        }
        this.myUrl = file2.getUrl();
        this.myFile = file2;
    }

    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @NotNull
    public String getUrl() {
        String string2 = this.myUrl;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getUrl"));
        }
        return string2;
    }

    @NotNull
    public String getFileName() {
        if (this.myFile != null) {
            String string2 = this.myFile.getName();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getFileName"));
            }
            return string2;
        }
        int index = this.myUrl.lastIndexOf(47);
        String string3 = index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getFileName"));
        }
        return string3;
    }

    @NotNull
    public String getPresentableUrl() {
        VirtualFile file2 = this.getFile();
        if (file2 != null) {
            String string2 = file2.getPresentableUrl();
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getPresentableUrl"));
            }
            return string2;
        }
        String string3 = LightFilePointer.toPresentableUrl(this.myUrl);
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "getPresentableUrl"));
        }
        return string3;
    }

    @NotNull
    private static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/LightFilePointer", "toPresentableUrl"));
        }
        String path = VirtualFileManager.extractPath((String)url);
        String protocol2 = VirtualFileManager.extractProtocol((String)url);
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol2);
        String string2 = ((VirtualFileSystem)ObjectUtils.notNull((Object)fileSystem, (Object)StandardFileSystems.local())).extractPresentableUrl(path);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/LightFilePointer", "toPresentableUrl"));
        }
        return string2;
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        if (this.myFile != null && this.myFile.isValid()) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o2).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }
}

