/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFileImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.openapi.vfs.impl.http.RemoteFileManagerImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Urls;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class HttpFileSystemBase
extends HttpFileSystem {
    private final String myProtocol;

    public HttpFileSystemBase(String protocol2) {
        this.myProtocol = protocol2;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "findFileByPath"));
        }
        return this.findFileByPath(path, false);
    }

    public VirtualFile findFileByPath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "findFileByPath"));
        }
        return HttpFileSystemBase.getRemoteFileManager().getOrCreateFile(null, Urls.newFromIdea(VirtualFileManager.constructUrl((String)this.myProtocol, (String)path)), path, isDirectory);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "addFileListener"));
        }
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener2);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "addFileListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "addFileListener"));
        }
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener2, parentDisposable);
    }

    public void removeFileListener(@NotNull HttpVirtualFileListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "removeFileListener"));
        }
        HttpFileSystemBase.getRemoteFileManager().removeFileListener(listener2);
    }

    public boolean isFileDownloaded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "isFileDownloaded"));
        }
        return file2 instanceof HttpVirtualFile && ((HttpVirtualFile)file2).getFileInfo().getState() == RemoteFileState.DOWNLOADED;
    }

    @NotNull
    public VirtualFile createChild(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChild"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChild"));
        }
        String parentPath = parent.getPath();
        boolean hasEndSlash = parentPath.charAt(parentPath.length() - 1) == '/';
        HttpVirtualFileImpl httpVirtualFileImpl = HttpFileSystemBase.getRemoteFileManager().getOrCreateFile((HttpVirtualFileImpl)parent, Urls.newFromIdea(parent.getUrl() + (hasEndSlash ? "" : Character.valueOf('/')) + name), parentPath + (hasEndSlash ? "" : Character.valueOf('/')) + name, isDirectory);
        if (httpVirtualFileImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChild"));
        }
        return httpVirtualFileImpl;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildDirectory"));
        }
        VirtualFile virtualFile = this.createChild(vDir, dirName, true);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildDirectory"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildFile"));
        }
        VirtualFile virtualFile = this.createChild(vDir, fileName, false);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "createChildFile"));
        }
        return virtualFile;
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "extractPresentableUrl"));
        }
        String string2 = VirtualFileManager.constructUrl((String)this.myProtocol, (String)path);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "extractPresentableUrl"));
        }
        return string2;
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "refreshAndFindFileByPath"));
        }
        return this.findFileByPath(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @NotNull
    public String getProtocol() {
        String string2 = this.myProtocol;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase", "getProtocol"));
        }
        return string2;
    }

    private static RemoteFileManagerImpl getRemoteFileManager() {
        return (RemoteFileManagerImpl)RemoteFileManager.getInstance();
    }
}

