/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarVirtualFile
extends VirtualFile {
    private final CoreJarHandler myHandler;
    private final CharSequence myName;
    private final long myLength;
    private final long myTimestamp;
    private final VirtualFile myParent;
    private VirtualFile[] myChildren;

    /*
     * WARNING - void declaration
     */
    public CoreJarVirtualFile(@NotNull CoreJarHandler handler2, @NotNull CharSequence name, long length, long timestamp, @Nullable CoreJarVirtualFile coreJarVirtualFile) {
        void parent;
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "<init>"));
        }
        this.myChildren = VirtualFile.EMPTY_ARRAY;
        this.myHandler = handler2;
        this.myName = name;
        this.myLength = length;
        this.myTimestamp = timestamp;
        this.myParent = parent;
    }

    void setChildren(VirtualFile[] children2) {
        this.myChildren = children2;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getName"));
        }
        return string2;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myHandler.getFileSystem();
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getFileSystem"));
        }
        return coreJarFileSystem;
    }

    @NotNull
    public String getPath() {
        if (this.myParent == null) {
            String string2 = FileUtil.toSystemIndependentName((String)this.myHandler.getFile().getPath()) + "!/";
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getPath"));
            }
            return string2;
        }
        String parentPath = this.myParent.getPath();
        StringBuilder answer = new StringBuilder(parentPath.length() + 1 + this.myName.length());
        answer.append(parentPath);
        if (answer.charAt(answer.length() - 1) != '/') {
            answer.append('/');
        }
        answer.append(this.myName);
        String string3 = answer.toString();
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getPath"));
        }
        return string3;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return this.myLength < 0L;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return this.myChildren;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        Couple<String> pair = ((CoreJarFileSystem)this.getFileSystem()).splitPath(this.getPath());
        byte[] byArray = this.myHandler.contentsToByteArray((String)pair.second);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    public long getTimeStamp() {
        return this.myTimestamp;
    }

    public long getLength() {
        return this.myLength;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray());
    }

    public long getModificationStamp() {
        return 0L;
    }
}

