/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;

public class VirtualFileInfoAction
extends AnAction
implements DumbAware {
    public static final DateFormat DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(1, 1);

    public void actionPerformed(AnActionEvent e2) {
        String pathToFile = Messages.showInputDialog((String)"Path to file: ", (String)"Virtual File Info", (Icon)Messages.getQuestionIcon());
        if (pathToFile == null) {
            return;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(pathToFile));
        if (virtualFile == null) {
            Messages.showErrorDialog((String)"Cannot find virtual file", (String)"Virtual File Info");
            return;
        }
        StringBuffer info = new StringBuffer();
        info.append("Path: ");
        info.append(virtualFile.getPath());
        info.append("\n");
        info.append("Time stamp: ");
        info.append(DATE_FORMAT.format(new Date(virtualFile.getTimeStamp())));
        info.append("\n");
        info.append("isValid: ");
        info.append(String.valueOf(virtualFile.isValid()));
        info.append("\n");
        info.append("isWritable: ");
        info.append(String.valueOf(virtualFile.isWritable()));
        info.append("\n");
        info.append("Content: ");
        try {
            info.append(VfsUtil.loadText((VirtualFile)virtualFile));
        }
        catch (IOException e1) {
            info.append("<unable to load content>");
            info.append(e1.getMessage());
        }
        info.append("\n");
        Messages.showMessageDialog((String)info.toString(), (String)"Virtual File Info", (Icon)Messages.getInformationIcon());
    }
}

