/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.newvfs.impl.VfsData");
    private static final int SEGMENT_BITS = 9;
    private static final int SEGMENT_SIZE = 512;
    private static final int OFFSET_MASK = 511;
    private static final Object ourDeadMarker = new String("dead file");
    private static final ConcurrentIntObjectMap<Segment> ourSegments = ContainerUtil.createConcurrentIntObjectMap();
    private static final ConcurrentBitSet ourInvalidatedIds = new ConcurrentBitSet();
    private static TIntHashSet ourDyingIds = new TIntHashSet();
    private static final ConcurrentIntObjectMap<VirtualDirectoryImpl> ourChangedParents = ContainerUtil.createConcurrentIntObjectMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void killInvalidatedFiles() {
        Object object = ourDeadMarker;
        synchronized (object) {
            if (!ourDyingIds.isEmpty()) {
                for (int id : ourDyingIds.toArray()) {
                    ((Segment)ObjectUtils.assertNotNull((Object)VfsData.getSegment(id, false))).myObjectArray.set(VfsData.getOffset(id), ourDeadMarker);
                    ourChangedParents.remove(id);
                }
                ourDyingIds = new TIntHashSet();
            }
        }
    }

    @Nullable
    public static VirtualFileSystemEntry getFileById(int id, VirtualDirectoryImpl parent) {
        Segment segment = VfsData.getSegment(id, false);
        if (segment == null) {
            return null;
        }
        int offset = VfsData.getOffset(id);
        Object o2 = segment.myObjectArray.get(offset);
        if (o2 == null) {
            return null;
        }
        if (o2 == ourDeadMarker) {
            throw VfsData.reportDeadFileAccess(new VirtualFileImpl(id, segment, parent));
        }
        int nameId = segment.getNameId(id);
        if (nameId <= 0) {
            FSRecords.invalidateCaches();
            throw new AssertionError((Object)("nameId=" + nameId + "; data=" + o2 + "; parent=" + (Object)((Object)parent) + "; parent.id=" + parent.getId() + "; db.parent=" + FSRecords.getParent(id)));
        }
        return o2 instanceof DirectoryData ? new VirtualDirectoryImpl(id, segment, (DirectoryData)o2, parent, parent.getFileSystem()) : new VirtualFileImpl(id, segment, parent);
    }

    private static InvalidVirtualFileAccessException reportDeadFileAccess(VirtualFileSystemEntry file2) {
        return new InvalidVirtualFileAccessException("Accessing dead virtual file: " + file2.getUrl());
    }

    private static int getOffset(int id) {
        return id & 0x1FF;
    }

    @Nullable
    @Contract(value="_,true->!null")
    public static Segment getSegment(int id, boolean create2) {
        int key = id >>> 9;
        Segment segment = (Segment)ourSegments.get(key);
        if (segment != null || !create2) {
            return segment;
        }
        return (Segment)ourSegments.cacheOrGet(key, (Object)new Segment());
    }

    public static void initFile(int id, Segment segment, int nameId, @NotNull Object data) throws FileAlreadyCreatedException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/openapi/vfs/newvfs/impl/VfsData", "initFile"));
        }
        assert (id > 0);
        int offset = VfsData.getOffset(id);
        segment.setNameId(id, nameId);
        Object existingData = segment.myObjectArray.get(offset);
        if (existingData != null) {
            FSRecords.invalidateCaches();
            int parent = FSRecords.getParent(id);
            String msg = "File already created: " + nameId + ", data=" + existingData + "; parentId=" + parent;
            if (parent > 0) {
                msg = msg + "; parent.name=" + FSRecords.getName(parent);
                msg = msg + "; parent.children=" + Arrays.toString(FSRecords.listAll(id));
            }
            throw new FileAlreadyCreatedException(msg);
        }
        segment.myObjectArray.set(offset, data);
    }

    static CharSequence getNameByFileId(int id) {
        return FileNameCache.getVFileName(((Segment)ObjectUtils.assertNotNull((Object)VfsData.getSegment(id, false))).getNameId(id));
    }

    static boolean isFileValid(int id) {
        return !ourInvalidatedIds.get(id);
    }

    @Nullable
    static VirtualDirectoryImpl getChangedParent(int id) {
        return (VirtualDirectoryImpl)((Object)ourChangedParents.get(id));
    }

    static void changeParent(int id, VirtualDirectoryImpl parent) {
        ourChangedParents.put(id, (Object)parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateFile(int id) {
        ourInvalidatedIds.set(id);
        Object object = ourDeadMarker;
        synchronized (object) {
            ourDyingIds.add(id);
        }
    }

    static {
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void writeActionFinished(@NotNull Object action2) {
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/vfs/newvfs/impl/VfsData$1", "writeActionFinished"));
                }
                if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    VfsData.killInvalidatedFiles();
                }
            }
        });
    }

    public static class DirectoryData {
        private static final AtomicFieldUpdater<DirectoryData, KeyFMap> updater = AtomicFieldUpdater.forFieldOfType(DirectoryData.class, KeyFMap.class);
        @NotNull
        volatile KeyFMap myUserMap = KeyFMap.EMPTY_MAP;
        @NotNull
        int[] myChildrenIds = ArrayUtil.EMPTY_INT_ARRAY;
        private Set<String> myAdoptedNames;

        VirtualFileSystemEntry[] getFileChildren(int fileId, VirtualDirectoryImpl parent) {
            assert (fileId > 0);
            VirtualFileSystemEntry[] children2 = new VirtualFileSystemEntry[this.myChildrenIds.length];
            for (int i2 = 0; i2 < this.myChildrenIds.length; ++i2) {
                children2[i2] = (VirtualFileSystemEntry)((Object)ObjectUtils.assertNotNull((Object)((Object)VfsData.getFileById(this.myChildrenIds[i2], parent))));
            }
            return children2;
        }

        boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
            return updater.compareAndSet((Object)this, (Object)oldMap, (Object)newMap);
        }

        boolean isAdoptedName(String name) {
            return this.myAdoptedNames != null && this.myAdoptedNames.contains(name);
        }

        void removeAdoptedName(String name) {
            if (this.myAdoptedNames != null) {
                this.myAdoptedNames.remove(name);
                if (this.myAdoptedNames.isEmpty()) {
                    this.myAdoptedNames = null;
                }
            }
        }

        void addAdoptedName(String name, boolean caseSensitive) {
            if (this.myAdoptedNames == null) {
                this.myAdoptedNames = new THashSet(0, (TObjectHashingStrategy)(caseSensitive ? TObjectHashingStrategy.CANONICAL : CaseInsensitiveStringHashingStrategy.INSTANCE));
            }
            this.myAdoptedNames.add(name);
        }

        List<String> getAdoptedNames() {
            return this.myAdoptedNames == null ? Collections.emptyList() : ContainerUtil.newArrayList(this.myAdoptedNames);
        }

        void clearAdoptedNames() {
            this.myAdoptedNames = null;
        }

        public String toString() {
            return "DirectoryData{myUserMap=" + this.myUserMap + ", myChildrenIds=" + Arrays.toString(this.myChildrenIds) + ", myAdoptedNames=" + this.myAdoptedNames + '}';
        }
    }

    public static class Segment {
        private final AtomicReferenceArray<Object> myObjectArray = new AtomicReferenceArray(512);
        private final AtomicIntegerArray myIntArray = new AtomicIntegerArray(1024);

        int getNameId(int fileId) {
            return this.myIntArray.get(VfsData.getOffset(fileId) * 2);
        }

        void setNameId(int fileId, int nameId) {
            this.myIntArray.set(VfsData.getOffset(fileId) * 2, nameId);
        }

        void setUserMap(int fileId, @NotNull KeyFMap map2) {
            if (map2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/newvfs/impl/VfsData$Segment", "setUserMap"));
            }
            this.myObjectArray.set(VfsData.getOffset(fileId), map2);
        }

        KeyFMap getUserMap(VirtualFileSystemEntry file2, int id) {
            Object o2 = this.myObjectArray.get(VfsData.getOffset(id));
            if (!(o2 instanceof KeyFMap)) {
                throw VfsData.reportDeadFileAccess(file2);
            }
            return (KeyFMap)o2;
        }

        boolean changeUserMap(int fileId, KeyFMap oldMap, KeyFMap newMap) {
            return this.myObjectArray.compareAndSet(VfsData.getOffset(fileId), oldMap, newMap);
        }

        boolean getFlag(int id, int mask) {
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            return (this.myIntArray.get(VfsData.getOffset(id) * 2 + 1) & mask) != 0;
        }

        void setFlag(int id, int mask, boolean value2) {
            int updated;
            int oldInt;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set flag " + Integer.toHexString(mask) + "=" + value2 + " for id=" + id);
            }
            assert ((mask & 0xFFFFFF) == 0) : "Unexpected flag";
            int offset = VfsData.getOffset(id) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = value2 ? oldInt | mask : oldInt & ~mask)) {
            }
        }

        long getModificationStamp(int id) {
            return this.myIntArray.get(VfsData.getOffset(id) * 2 + 1) & 0xFFFFFF;
        }

        void setModificationStamp(int id, long stamp) {
            int updated;
            int oldInt;
            int offset = VfsData.getOffset(id) * 2 + 1;
            while (!this.myIntArray.compareAndSet(offset, oldInt = this.myIntArray.get(offset), updated = oldInt & 0xFF000000 | (int)stamp & 0xFFFFFF)) {
            }
        }
    }

    public static class FileAlreadyCreatedException
    extends Exception {
        private FileAlreadyCreatedException(String message2) {
            super(message2);
        }
    }
}

