/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.keyFMap.KeyFMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileImpl
extends VirtualFileSystemEntry {
    private static final Key<byte[]> ourPreloadedContentKey = Key.create((String)"preloaded.content.key");

    VirtualFileImpl(int id, VfsData.Segment segment, VirtualDirectoryImpl parent) {
        super(id, segment, parent);
    }

    @Nullable
    public NewVirtualFile findChild(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "findChild"));
        }
        return null;
    }

    @NotNull
    public Collection<VirtualFile> getCachedChildren() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getCachedChildren"));
        }
        return list2;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        Iterable iterable = ContainerUtil.emptyIterable();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "iterInDbChildren"));
        }
        return iterable;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        VirtualDirectoryImpl parent = this.getParent();
        assert (parent != null);
        NewVirtualFileSystem newVirtualFileSystem = parent.getFileSystem();
        if (newVirtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getFileSystem"));
        }
        return newVirtualFileSystem;
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "refreshAndFindChild"));
        }
        return null;
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "findChildIfCached"));
        }
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public boolean isDirectory() {
        return false;
    }

    public void setPreloadedContentHint(byte[] preloadedContentHint) {
        this.putUserData(ourPreloadedContentKey, preloadedContentHint);
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM((InputStream)(preloadedContent == null ? ourPersistence.getInputStream((VirtualFile)this) : new DataInputStream((InputStream)new UnsyncByteArrayInputStream(preloadedContent))), (VirtualFile)this);
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getInputStream"));
        }
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = this.contentsToByteArray(true);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    public byte[] contentsToByteArray(boolean cacheContent) throws IOException {
        this.checkNotTooLarge(null);
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        if (preloadedContent != null) {
            if (preloadedContent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "contentsToByteArray"));
            }
            return preloadedContent;
        }
        byte[] byArray = ourPersistence.contentsToByteArray((VirtualFile)this, cacheContent);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "contentsToByteArray"));
        }
        return byArray;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long modStamp, long timeStamp) throws IOException {
        this.checkNotTooLarge(requestor);
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)ourPersistence.getOutputStream((VirtualFile)this, requestor, modStamp, timeStamp), (VirtualFile)this);
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getOutputStream"));
        }
        return outputStream;
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(@NotNull byte[] content2, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "setBinaryContent"));
        }
        this.checkNotTooLarge(requestor);
        super.setBinaryContent(content2, newModificationStamp, newTimeStamp, (Object)requestor);
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(@NotNull byte[] content2, long newModificationStamp, long l2) throws IOException {
        void newTimeStamp;
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "setBinaryContent"));
        }
        this.checkNotTooLarge(null);
        super.setBinaryContent(content2, newModificationStamp, (long)newTimeStamp);
    }

    public String getDetectedLineSeparator() {
        if (this.getFlagInt(0x8000000)) {
            return LineSeparator.getSystemLineSeparator().getSeparatorString();
        }
        return super.getDetectedLineSeparator();
    }

    public void setDetectedLineSeparator(String separator) {
        boolean hasSystemSeparator = LineSeparator.getSystemLineSeparator().getSeparatorString().equals(separator);
        this.setFlagInt(0x8000000, hasSystemSeparator);
        super.setDetectedLineSeparator(hasSystemSeparator ? null : separator);
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "setUserMap"));
        }
        this.mySegment.setUserMap(this.myId, map2);
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = this.mySegment.getUserMap(this, this.myId);
        if (keyFMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl", "getUserMap"));
        }
        return keyFMap;
    }

    protected boolean changeUserMap(KeyFMap oldMap, KeyFMap newMap) {
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.mySegment.changeUserMap(this.myId, oldMap, UserDataInterner.internUserData(newMap));
    }

    private void checkNotTooLarge(@Nullable Object requestor) throws FileTooBigException {
        if (!(requestor instanceof LargeFileWriteRequestor) && this.isTooLarge()) {
            throw new FileTooBigException(this.getPath());
        }
    }

    private boolean isTooLarge() {
        return FileUtilRt.isTooLarge((long)this.getLength());
    }
}

