/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.RecordIdIterator;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;

public class CompactRecordsTable
extends AbstractRecordsTable {
    private final byte[] zeroes = new byte[this.getRecordSize()];
    private final boolean forceSplit;
    private static final int ADDRESS_OFFSET = 0;
    private static final int SIZE_AND_CAPACITY_OFFSET = 4;
    private static final int SIZE_OFFSET_IN_INDIRECT_RECORD = 0;
    private static final int CAPACITY_OFFSET_IN_INDIRECT_RECORD = 4;
    private static final int SIZE_MASK = 65535;
    private static final int CAPACITY_MASK = 0x7FFF0000;
    private static final int CAPACITY_SHIFT = 16;
    private static final int SPECIAL_POSITIVE_VALUE_FOR_SPECIAL_NEGATIVE_SIZE = 65535;
    private static final int SPECIAL_NEGATIVE_SIZE = -1;

    public CompactRecordsTable(File recordsFile, PagePool pool, boolean forceSplit) throws IOException {
        super(recordsFile, pool);
        this.forceSplit = forceSplit;
    }

    protected int getImplVersion() {
        return 1;
    }

    protected int getRecordSize() {
        return 8;
    }

    protected byte[] getZeros() {
        return this.zeroes;
    }

    public long getAddress(int record) {
        int address = this.myStorage.getInt((long)this.getOffset(record, 0));
        if (address < 0) {
            return super.getAddress(-address);
        }
        return address;
    }

    public void setAddress(int record, long address) {
        this.markDirty();
        int addressOfRecordAbsoluteOffset = this.getOffset(record, 0);
        int existing_address = this.myStorage.getInt((long)addressOfRecordAbsoluteOffset);
        if (existing_address < 0) {
            super.setAddress(-existing_address, address);
            return;
        }
        if (address > Integer.MAX_VALUE || address < 0L || this.forceSplit) {
            int extendedRecord = this.doCreateNewRecord();
            super.setAddress(extendedRecord, address);
            this.myStorage.putInt((long)addressOfRecordAbsoluteOffset, -extendedRecord);
        } else {
            this.myStorage.putInt((long)addressOfRecordAbsoluteOffset, (int)address);
        }
    }

    private int doCreateNewRecord() {
        try {
            return this.createNewRecord();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getSize(int record) {
        int currentValue = this.myStorage.getInt((long)this.getOffset(record, 4));
        if (currentValue < 0) {
            return this.myStorage.getInt((long)this.getOffset(-currentValue, 0));
        }
        int i2 = currentValue & 0xFFFF;
        if (i2 == 65535) {
            i2 = -1;
        }
        return i2;
    }

    public void setSize(int record, int size) {
        this.markDirty();
        int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(record, 4);
        int currentValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
        if (currentValue < 0) {
            this.myStorage.putInt((long)this.getOffset(-currentValue, 0), size);
            return;
        }
        if (size >= 65535 || size < -1 || this.forceSplit) {
            this.extendSizeAndCapacityRecord(record, size, this.getCapacity(record));
            return;
        }
        if (size == -1) {
            size = 65535;
        }
        this.myStorage.putInt((long)sizeAndCapacityOfRecordAbsoluteOffset, size | currentValue & 0x7FFF0000);
    }

    private void extendSizeAndCapacityRecord(int record, int size, int capacity) {
        int extendedRecord = this.doCreateNewRecord();
        this.myStorage.putInt((long)this.getOffset(extendedRecord, 0), size);
        this.myStorage.putInt((long)this.getOffset(extendedRecord, 4), capacity);
        this.myStorage.putInt((long)this.getOffset(record, 4), -extendedRecord);
    }

    public int getCapacity(int record) {
        int currentValue = this.myStorage.getInt((long)this.getOffset(record, 4));
        if (currentValue < 0) {
            return this.myStorage.getInt((long)this.getOffset(-currentValue, 4));
        }
        return (currentValue & 0x7FFF0000) >> 16;
    }

    public void setCapacity(int record, int capacity) {
        this.markDirty();
        int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(record, 4);
        int currentValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
        if (currentValue < 0) {
            this.myStorage.putInt((long)this.getOffset(-currentValue, 4), capacity);
            return;
        }
        if (capacity > Short.MAX_VALUE || capacity < 0 || this.forceSplit) {
            this.extendSizeAndCapacityRecord(record, this.getSize(record), capacity);
            return;
        }
        this.myStorage.putInt((long)sizeAndCapacityOfRecordAbsoluteOffset, currentValue & 0xFFFF | capacity << 16);
    }

    public void deleteRecord(int record) throws IOException {
        int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(record, 4);
        int sizeAndCapacityValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
        int addressOfRecordAbsoluteOffset = this.getOffset(record, 0);
        int existingAddressValue = this.myStorage.getInt((long)addressOfRecordAbsoluteOffset);
        super.deleteRecord(record);
        if (sizeAndCapacityValue < 0) {
            super.deleteRecord(-sizeAndCapacityValue);
        }
        if (existingAddressValue < 0) {
            super.deleteRecord(-existingAddressValue);
        }
    }

    public RecordIdIterator createRecordIdIterator() throws IOException {
        final BitSet extraRecordsIds = this.buildIdSetOfExtraRecords();
        final RecordIdIterator iterator2 = super.createRecordIdIterator();
        return new RecordIdIterator(){
            int nextId = this.scanToNextId();

            private int scanToNextId() {
                while (iterator2.hasNextId()) {
                    int next = iterator2.nextId();
                    if (extraRecordsIds.get(next)) continue;
                    return next;
                }
                return -1;
            }

            public boolean hasNextId() {
                return this.nextId != -1;
            }

            public int nextId() {
                assert (this.hasNextId());
                int result2 = this.nextId;
                this.nextId = this.scanToNextId();
                return result2;
            }

            public boolean validId() {
                assert (this.hasNextId());
                return CompactRecordsTable.this.getSize(this.nextId) != -1;
            }
        };
    }

    @NotNull
    private BitSet buildIdSetOfExtraRecords() throws IOException {
        BitSet extraRecords = new BitSet();
        RecordIdIterator iterator2 = super.createRecordIdIterator();
        while (iterator2.hasNextId()) {
            int recordId = iterator2.nextId();
            int sizeAndCapacityOfRecordAbsoluteOffset = this.getOffset(recordId, 4);
            int sizeAndCapacityValue = this.myStorage.getInt((long)sizeAndCapacityOfRecordAbsoluteOffset);
            int addressOfRecordAbsoluteOffset = this.getOffset(recordId, 0);
            int existingAddressValue = this.myStorage.getInt((long)addressOfRecordAbsoluteOffset);
            if (sizeAndCapacityValue < 0) {
                extraRecords.set(-sizeAndCapacityValue);
            }
            if (existingAddressValue >= 0) continue;
            extraRecords.set(-existingAddressValue);
        }
        BitSet bitSet = extraRecords;
        if (bitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/persistent/CompactRecordsTable", "buildIdSetOfExtraRecords"));
        }
        return bitSet;
    }
}

