/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class FloatingDecorator
extends JDialog {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.FloatingDecorator");
    static final int DIVIDER_WIDTH = 3;
    private static final int ANCHOR_TOP = 1;
    private static final int ANCHOR_LEFT = 2;
    private static final int ANCHOR_BOTTOM = 4;
    private static final int ANCHOR_RIGHT = 8;
    private static final int DELAY = 15;
    private static final int TOTAL_FRAME_COUNT = 7;
    private final InternalDecorator myInternalDecorator;
    private final MyUISettingsListener myUISettingsListener;
    private WindowInfoImpl myInfo;
    private final Disposable myDisposable;
    private final Alarm myDelayAlarm;
    private final Alarm myFrameTicker;
    private final MyAnimator myAnimator;
    private int myCurrentFrame;
    private float myStartRatio;
    private float myEndRatio;

    FloatingDecorator(IdeFrameImpl owner, @NotNull WindowInfoImpl info, @NotNull InternalDecorator internalDecorator) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/FloatingDecorator", "<init>"));
        }
        if (internalDecorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalDecorator", "com/intellij/openapi/wm/impl/FloatingDecorator", "<init>"));
        }
        super((Frame)owner, internalDecorator.getToolWindow().getId());
        this.myDisposable = Disposer.newDisposable();
        MnemonicHelper.init((Component)this.getContentPane());
        this.myInternalDecorator = internalDecorator;
        this.setDefaultCloseOperation(0);
        JComponent cp = (JComponent)this.getContentPane();
        cp.setLayout(new BorderLayout());
        if (SystemInfo.isWindows) {
            this.setUndecorated(true);
            cp.add((Component)new BorderItem(1), "North");
            cp.add((Component)new BorderItem(2), "West");
            cp.add((Component)new BorderItem(4), "South");
            cp.add((Component)new BorderItem(8), "East");
            cp.add((Component)this.myInternalDecorator, "Center");
        } else {
            cp.add((Component)this.myInternalDecorator, "Center");
            this.getRootPane().putClientProperty("Window.style", "small");
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new MyWindowListener());
        this.myDelayAlarm = new Alarm();
        this.myFrameTicker = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        this.myAnimator = new MyAnimator();
        this.myCurrentFrame = 0;
        this.myStartRatio = 0.0f;
        this.myEndRatio = 0.0f;
        this.myUISettingsListener = new MyUISettingsListener();
        IdeGlassPaneImpl ideGlassPane = new IdeGlassPaneImpl(this.getRootPane(), true);
        this.getRootPane().setGlassPane(ideGlassPane);
        ideGlassPane.addMousePreprocessor(new MouseAdapter(){}, this.myDisposable);
        this.apply(info);
    }

    @Override
    public final void show() {
        this.setFocusableWindowState(this.myInfo.isActive());
        super.show();
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getEnableAlphaMode()) {
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            windowManager.setAlphaModeEnabled(this, true);
            if (this.myInfo.isActive()) {
                windowManager.setAlphaModeRatio(this, 0.0f);
            } else {
                windowManager.setAlphaModeRatio(this, uiSettings.getAlphaModeRatio());
            }
        }
        this.paint(this.getGraphics());
        this.setFocusableWindowState(true);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myDelayAlarm).subscribe(UISettingsListener.TOPIC, (Object)this.myUISettingsListener);
    }

    @Override
    public final void dispose() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this.getParent())) {
            Disposer.dispose((Disposable)this.myDelayAlarm);
            Disposer.dispose((Disposable)this.myDisposable);
        } else if (this.isShowing()) {
            SwingUtilities.invokeLater(() -> this.show());
        }
        super.dispose();
    }

    final void apply(@NotNull WindowInfoImpl info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/wm/impl/FloatingDecorator", "apply"));
        }
        LOG.assertTrue(info.isFloating());
        this.myInfo = info;
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getEnableAlphaMode() && this.isShowing() && this.isDisplayable()) {
            this.myDelayAlarm.cancelAllRequests();
            if (this.myInfo.isActive()) {
                this.myFrameTicker.cancelAllRequests();
                this.myStartRatio = this.getCurrentAlphaRatio();
                if (this.myCurrentFrame > 0) {
                    this.myCurrentFrame = 7 - this.myCurrentFrame;
                }
                this.myEndRatio = 0.0f;
                this.myFrameTicker.addRequest((Runnable)this.myAnimator, 15);
            } else {
                this.myDelayAlarm.addRequest(() -> {
                    this.myFrameTicker.cancelAllRequests();
                    this.myStartRatio = this.getCurrentAlphaRatio();
                    if (this.myCurrentFrame > 0) {
                        this.myCurrentFrame = 7 - this.myCurrentFrame;
                    }
                    this.myEndRatio = uiSettings.getAlphaModeRatio();
                    this.myFrameTicker.addRequest((Runnable)this.myAnimator, 15);
                }, uiSettings.getAlphaModeDelay());
            }
        }
    }

    private float getCurrentAlphaRatio() {
        float delta = (this.myEndRatio - this.myStartRatio) / 7.0f;
        if (this.myStartRatio > this.myEndRatio) {
            delta *= 2.0f;
        }
        float ratio = this.myStartRatio + (float)this.myCurrentFrame * delta;
        return Math.min(1.0f, Math.max(0.0f, ratio));
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings uiSettings) {
            LOG.assertTrue(FloatingDecorator.this.isDisplayable());
            LOG.assertTrue(FloatingDecorator.this.isShowing());
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            FloatingDecorator.this.myDelayAlarm.cancelAllRequests();
            if (uiSettings.getEnableAlphaMode()) {
                if (!FloatingDecorator.this.myInfo.isActive()) {
                    windowManager.setAlphaModeEnabled(FloatingDecorator.this, true);
                    windowManager.setAlphaModeRatio(FloatingDecorator.this, uiSettings.getAlphaModeRatio());
                }
            } else {
                windowManager.setAlphaModeEnabled(FloatingDecorator.this, false);
            }
        }
    }

    private final class MyAnimator
    implements Runnable {
        private MyAnimator() {
        }

        @Override
        public final void run() {
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            if (FloatingDecorator.this.isDisplayable() && FloatingDecorator.this.isShowing()) {
                windowManager.setAlphaModeRatio(FloatingDecorator.this, FloatingDecorator.this.getCurrentAlphaRatio());
            }
            if (FloatingDecorator.this.myCurrentFrame < 7) {
                FloatingDecorator.this.myCurrentFrame++;
                FloatingDecorator.this.myFrameTicker.addRequest((Runnable)FloatingDecorator.this.myAnimator, 15);
            } else {
                FloatingDecorator.this.myFrameTicker.cancelAllRequests();
            }
        }
    }

    private final class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e2) {
            FloatingDecorator.this.myInternalDecorator.fireResized();
            FloatingDecorator.this.myInternalDecorator.fireHidden();
        }
    }

    private final class BorderItem
    extends JPanel {
        private static final int RESIZER_WIDTH = 10;
        private final int myAnchor;
        private int myMotionMask;
        private Point myLastPoint;
        private boolean myDragging;

        public BorderItem(int anchor) {
            this.myAnchor = anchor;
            this.enableEvents(48L);
        }

        @Override
        protected final void processMouseMotionEvent(MouseEvent e2) {
            super.processMouseMotionEvent(e2);
            if (506 == e2.getID() && this.myLastPoint != null) {
                Point offset;
                Point newPoint = e2.getPoint();
                SwingUtilities.convertPointToScreen(newPoint, this);
                Rectangle screenBounds = WindowManagerEx.getInstanceEx().getScreenBounds();
                int screenMaxX = screenBounds.x + screenBounds.width;
                int screenMaxY = screenBounds.y + screenBounds.height;
                newPoint.x = Math.min(Math.max(newPoint.x, screenBounds.x), screenMaxX);
                newPoint.y = Math.min(Math.max(newPoint.y, screenBounds.y), screenMaxY);
                Rectangle oldBounds = FloatingDecorator.this.getBounds();
                Rectangle newBounds = new Rectangle(oldBounds);
                if ((this.myMotionMask & 1) > 0) {
                    newPoint.y = Math.min(newPoint.y, oldBounds.y + oldBounds.height - 6);
                    if (newPoint.y < screenBounds.y + 3) {
                        newPoint.y = screenBounds.y;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.y = oldBounds.y + offset.y;
                    newBounds.height = oldBounds.height - offset.y;
                }
                if ((this.myMotionMask & 2) > 0) {
                    newPoint.x = Math.min(newPoint.x, oldBounds.x + oldBounds.width - 6);
                    if (newPoint.x < screenBounds.x + 3) {
                        newPoint.x = screenBounds.x;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.x = oldBounds.x + offset.x;
                    newBounds.width = oldBounds.width - offset.x;
                }
                if ((this.myMotionMask & 4) > 0) {
                    newPoint.y = Math.max(newPoint.y, oldBounds.y + 6);
                    if (newPoint.y > screenMaxY - 3) {
                        newPoint.y = screenMaxY;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.height = oldBounds.height + offset.y;
                }
                if ((this.myMotionMask & 8) > 0) {
                    newPoint.x = Math.max(newPoint.x, oldBounds.x + 6);
                    if (newPoint.x > screenMaxX - 3) {
                        newPoint.x = screenMaxX;
                    }
                    offset = new Point(newPoint.x - this.myLastPoint.x, newPoint.y - this.myLastPoint.y);
                    newBounds.width = oldBounds.width + offset.x;
                }
                FloatingDecorator.this.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
                this.myLastPoint = newPoint;
            } else if (e2.getID() == 503 && !this.myDragging) {
                this.setMotionMask(e2.getPoint());
            }
        }

        @Override
        protected final void processMouseEvent(MouseEvent e2) {
            super.processMouseEvent(e2);
            switch (e2.getID()) {
                case 501: {
                    this.myLastPoint = e2.getPoint();
                    SwingUtilities.convertPointToScreen(this.myLastPoint, this);
                    this.setMotionMask(e2.getPoint());
                    this.myDragging = true;
                    break;
                }
                case 502: {
                    FloatingDecorator.this.validate();
                    FloatingDecorator.this.repaint();
                    this.myDragging = false;
                    break;
                }
                case 504: {
                    if (this.myDragging) break;
                    this.setMotionMask(e2.getPoint());
                }
            }
        }

        private void setMotionMask(Point p2) {
            this.myMotionMask = this.myAnchor;
            if (1 == this.myAnchor || 4 == this.myAnchor) {
                if (p2.getX() < 10.0) {
                    this.myMotionMask |= 2;
                } else if (p2.getX() > (double)(this.getWidth() - 10)) {
                    this.myMotionMask |= 8;
                }
            } else if (p2.getY() < 10.0) {
                this.myMotionMask |= 1;
            } else if (p2.getY() > (double)(this.getHeight() - 10)) {
                this.myMotionMask |= 4;
            }
            if (this.myMotionMask == 1) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else if (this.myMotionMask == 3) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (this.myMotionMask == 2) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else if (this.myMotionMask == 6) {
                this.setCursor(Cursor.getPredefinedCursor(4));
            } else if (this.myMotionMask == 4) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            } else if (this.myMotionMask == 12) {
                this.setCursor(Cursor.getPredefinedCursor(5));
            } else if (this.myMotionMask == 8) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (this.myMotionMask == 9) {
                this.setCursor(Cursor.getPredefinedCursor(7));
            }
        }

        @Override
        public final Dimension getPreferredSize() {
            Dimension d2 = super.getPreferredSize();
            if (1 == this.myAnchor || 4 == this.myAnchor) {
                d2.height = 3;
            } else {
                d2.width = 3;
            }
            return d2;
        }

        @Override
        public final void paint(Graphics g2) {
            super.paint(g2);
            JBColor lightGray = new JBColor(Color.lightGray, (Color)Gray._95);
            JBColor gray = new JBColor(Color.gray, (Color)Gray._95);
            if (1 == this.myAnchor) {
                g2.setColor((Color)lightGray);
                UIUtil.drawLine((Graphics)g2, (int)0, (int)0, (int)(this.getWidth() - 1), (int)0);
                UIUtil.drawLine((Graphics)g2, (int)0, (int)0, (int)0, (int)(this.getHeight() - 1));
                g2.setColor((Color)JBColor.GRAY);
                UIUtil.drawLine((Graphics)g2, (int)(this.getWidth() - 1), (int)0, (int)(this.getWidth() - 1), (int)(this.getHeight() - 1));
            } else if (2 == this.myAnchor) {
                g2.setColor((Color)lightGray);
                UIUtil.drawLine((Graphics)g2, (int)0, (int)0, (int)0, (int)(this.getHeight() - 1));
            } else if (4 == this.myAnchor) {
                g2.setColor((Color)lightGray);
                UIUtil.drawLine((Graphics)g2, (int)0, (int)0, (int)0, (int)(this.getHeight() - 1));
                g2.setColor((Color)gray);
                UIUtil.drawLine((Graphics)g2, (int)0, (int)(this.getHeight() - 1), (int)(this.getWidth() - 1), (int)(this.getHeight() - 1));
                UIUtil.drawLine((Graphics)g2, (int)(this.getWidth() - 1), (int)0, (int)(this.getWidth() - 1), (int)(this.getHeight() - 1));
            } else {
                g2.setColor((Color)gray);
                UIUtil.drawLine((Graphics)g2, (int)(this.getWidth() - 1), (int)0, (int)(this.getWidth() - 1), (int)(this.getHeight() - 1));
            }
        }
    }
}

