/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

public abstract class HierarchyWatcher
implements ContainerListener {
    @Override
    public final void componentAdded(ContainerEvent e2) {
        this.install(e2.getChild());
        this.hierarchyChanged(e2);
    }

    @Override
    public final void componentRemoved(ContainerEvent e2) {
        Component removedChild = e2.getChild();
        this.deinstall(removedChild);
        this.hierarchyChanged(e2);
    }

    private void install(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i2 = 0; i2 < componentCount; ++i2) {
                this.install(container.getComponent(i2));
            }
            container.addContainerListener(this);
        }
    }

    private void deinstall(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            int componentCount = container.getComponentCount();
            for (int i2 = 0; i2 < componentCount; ++i2) {
                this.deinstall(container.getComponent(i2));
            }
            container.removeContainerListener(this);
        }
    }

    protected abstract void hierarchyChanged(ContainerEvent var1);
}

