/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.PaintersHelper;
import com.intellij.openapi.wm.impl.ToolWindowHeader;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.util.ImageLoader;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeBackgroundUtil {
    public static final String EDITOR_PROP = "idea.background.editor";
    public static final String FRAME_PROP = "idea.background.frame";
    public static final String TARGET_PROP = "idea.background.target";
    private static final Set<String> ourKnownNames;
    static final RenderingHints.Key ADJUST_ALPHA;
    private static final JBIterable<Object> ourPreservedKeys;

    @NotNull
    public static Graphics2D withEditorBackground(@NotNull Graphics g2, @NotNull JComponent component) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        if (IdeBackgroundUtil.suppressBackground(component)) {
            Graphics2D graphics2D = (Graphics2D)g2;
            if (graphics2D == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
            }
            return graphics2D;
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g2, EDITOR_PROP, component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withEditorBackground"));
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withFrameBackground(@NotNull Graphics g2, @NotNull JComponent component) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        if (IdeBackgroundUtil.suppressBackground(component)) {
            Graphics2D graphics2D = (Graphics2D)g2;
            if (graphics2D == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
            }
            return graphics2D;
        }
        Graphics2D graphics2D = IdeBackgroundUtil.withNamedPainters(g2, FRAME_PROP, component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withFrameBackground"));
        }
        return graphics2D;
    }

    private static boolean suppressBackground(JComponent component) {
        String type = IdeBackgroundUtil.getComponentType(component);
        if (type == null) {
            return false;
        }
        String spec = System.getProperty(TARGET_PROP, "*");
        boolean allInclusive = spec.startsWith("*");
        return allInclusive && spec.contains("-" + type) || !allInclusive && !spec.contains(type);
    }

    private static String getComponentType(JComponent component) {
        return component instanceof JTree ? "tree" : (component instanceof JList ? "list" : (component instanceof JTable ? "table" : (component instanceof JViewport ? "viewport" : (component instanceof ActionToolbar ? "toolbar" : (component instanceof EditorsSplitters ? "frame" : (component instanceof EditorComponentImpl ? "editor" : (component instanceof EditorGutterComponentEx ? "editor" : (component instanceof JBLoadingPanel ? "loading" : (component instanceof JBTabs ? "tabs" : (component instanceof ToolWindowHeader ? "title" : (component instanceof JBPanelWithEmptyText ? "panel" : (component instanceof JPanel && ourKnownNames.contains(component.getName()) ? component.getName() : null))))))))))));
    }

    @NotNull
    public static Graphics2D getOriginalGraphics(@NotNull Graphics g2) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getOriginalGraphics"));
        }
        Graphics2D graphics2D = g2 instanceof MyGraphics ? ((MyGraphics)((Object)g2)).getDelegate() : (Graphics2D)g2;
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getOriginalGraphics"));
        }
        return graphics2D;
    }

    @NotNull
    public static Graphics2D withNamedPainters(@NotNull Graphics g2, @NotNull String paintersName, @NotNull JComponent component) {
        PaintersHelper helper;
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        if (paintersName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paintersName", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        JRootPane rootPane = component.getRootPane();
        Component glassPane = rootPane == null ? null : rootPane.getGlassPane();
        PaintersHelper paintersHelper = helper = glassPane instanceof IdeGlassPaneImpl ? ((IdeGlassPaneImpl)glassPane).getNamedPainters(paintersName) : null;
        if (helper == null || !helper.needsRepaint()) {
            Graphics2D graphics2D = (Graphics2D)g2;
            if (graphics2D == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
            }
            return graphics2D;
        }
        Graphics2D graphics2D = MyGraphics.wrap(g2, helper, component);
        if (graphics2D == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "withNamedPainters"));
        }
        return graphics2D;
    }

    public static void initEditorPainters(@NotNull IdeGlassPaneImpl glassPane) {
        if (glassPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "glassPane", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "initEditorPainters"));
        }
        PaintersHelper.initWallpaperPainter(EDITOR_PROP, glassPane.getNamedPainters(EDITOR_PROP));
    }

    public static void initFramePainters(@NotNull IdeGlassPaneImpl glassPane) {
        Image centerImage;
        if (glassPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "glassPane", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "initFramePainters"));
        }
        PaintersHelper painters = glassPane.getNamedPainters(FRAME_PROP);
        PaintersHelper.initWallpaperPainter(FRAME_PROP, painters);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String path = null;
        URL url = path == null ? null : ((Object)((Object)appInfo)).getClass().getResource(path);
        Image image = centerImage = url == null ? null : ImageLoader.loadFromUrl((URL)url);
        if (centerImage != null) {
            painters.addPainter((Painter)PaintersHelper.newImagePainter(centerImage, PaintersHelper.Fill.PLAIN, PaintersHelper.Place.TOP_CENTER, 1.0f, (Insets)JBUI.insets((int)10, (int)0, (int)0, (int)0)), null);
        }
        painters.addPainter((Painter)new AbstractPainter(){
            EditorEmptyTextPainter p = (EditorEmptyTextPainter)ServiceManager.getService(EditorEmptyTextPainter.class);

            public boolean needsRepaint() {
                return true;
            }

            public void executePaint(Component component, Graphics2D g2) {
                this.p.paintEmptyText((JComponent)component, g2);
            }
        }, null);
    }

    @Nullable
    public static Color getIdeBackgroundColor() {
        Color result2 = UIUtil.getSlightlyDarkerColor((Color)UIUtil.getPanelBackground());
        return UIUtil.isUnderDarcula() ? new Color(40, 40, 41) : UIUtil.getSlightlyDarkerColor((Color)UIUtil.getSlightlyDarkerColor((Color)result2));
    }

    public static void createTemporaryBackgroundTransform(JPanel root, String tmp, Disposable disposable) {
        PaintersHelper paintersHelper = new PaintersHelper(root);
        PaintersHelper.initWallpaperPainter(tmp, paintersHelper);
        Disposer.register((Disposable)disposable, (Disposable)JBSwingUtilities.addGlobalCGTransform((t2, v2) -> {
            if (!UIUtil.isAncestor((Component)root, (Component)t2)) {
                return v2;
            }
            return MyGraphics.wrap(v2, paintersHelper, t2);
        }));
    }

    @NotNull
    public static String getBackgroundSpec(@Nullable Project project2, @NotNull String propertyName) {
        String spec;
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getBackgroundSpec"));
        }
        String string2 = spec = project2 == null || project2.isDisposed() ? null : PropertiesComponent.getInstance((Project)project2).getValue(propertyName);
        if (spec == null) {
            spec = PropertiesComponent.getInstance().getValue(propertyName);
        }
        String string3 = StringUtil.notNullize((String)spec, (String)System.getProperty(propertyName, ""));
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil", "getBackgroundSpec"));
        }
        return string3;
    }

    public static boolean isEditorBackgroundImageSet(@Nullable Project project2) {
        return StringUtil.isNotEmpty((String)IdeBackgroundUtil.getBackgroundSpec(project2, EDITOR_PROP));
    }

    public static void repaintAllWindows() {
        for (Window window : Window.getWindows()) {
            window.repaint();
        }
    }

    static {
        JBSwingUtilities.addGlobalCGTransform((PairFunction)new MyTransform());
        ourKnownNames = ContainerUtil.newHashSet((Object[])new String[]{"navbar", "terminal"});
        ADJUST_ALPHA = new RenderingHints.Key(1){

            @Override
            public boolean isCompatibleValue(Object val) {
                return val instanceof Boolean;
            }
        };
        ourPreservedKeys = JBIterable.of((Object[])new Object[]{EditorColors.SELECTION_BACKGROUND_COLOR, DiffColors.DIFF_INSERTED, DiffColors.DIFF_DELETED, DiffColors.DIFF_MODIFIED, DiffColors.DIFF_CONFLICT});
    }

    private static class MyTransform
    implements PairFunction<JComponent, Graphics2D, Graphics2D> {
        private MyTransform() {
        }

        public Graphics2D fun(JComponent c2, Graphics2D g2) {
            Graphics2D gg;
            String type = IdeBackgroundUtil.getComponentType(c2);
            if (type == null) {
                return g2;
            }
            if ("frame".equals(type)) {
                return IdeBackgroundUtil.withFrameBackground(g2, c2);
            }
            if ("editor".equals(type)) {
                EditorImpl editor;
                EditorImpl editorImpl = c2 instanceof EditorComponentImpl ? ((EditorComponentImpl)c2).getEditor() : (editor = c2 instanceof EditorGutterComponentEx ? (Editor)CommonDataKeys.EDITOR.getData((DataProvider)c2) : null);
                if (editor != null) {
                    if (!(g2 instanceof MyGraphics) && Boolean.TRUE.equals(EditorTextField.SUPPLEMENTARY_KEY.get((UserDataHolder)editor))) {
                        return g2;
                    }
                    Graphics2D gg2 = IdeBackgroundUtil.withEditorBackground(g2, c2);
                    if (gg2 instanceof MyGraphics) {
                        EditorColorsScheme scheme2 = editor.getColorsScheme();
                        ((MyGraphics)((Object)gg2)).preserved = ourPreservedKeys.map(o2 -> {
                            if (o2 instanceof ColorKey) {
                                return scheme2.getColor((ColorKey)o2);
                            }
                            TextAttributes attrs = scheme2.getAttributes((TextAttributesKey)o2);
                            return attrs != null ? attrs.getBackgroundColor() : null;
                        }).toSet();
                    }
                    return gg2;
                }
            }
            if ((gg = IdeBackgroundUtil.withEditorBackground(g2, c2)) instanceof MyGraphics) {
                JComponent view2;
                Component component = view2 = c2 instanceof JViewport ? ((JViewport)c2).getView() : c2;
                Color selectionColor = view2 instanceof JTree ? UIUtil.getTreeSelectionBackground() : (view2 instanceof JList ? UIUtil.getListSelectionBackground() : (view2 instanceof JTable ? UIUtil.getTableSelectionBackground() : null));
                ((MyGraphics)((Object)gg)).preserved = ContainerUtil.createMaybeSingletonSet((Object)selectionColor);
            }
            return gg;
        }
    }

    private static class MyGraphics
    extends Graphics2DDelegate {
        final PaintersHelper helper;
        final int[] offsets;
        Set<Color> preserved;

        static Graphics2D wrap(Graphics g2, PaintersHelper helper, JComponent component) {
            MyGraphics gg = g2 instanceof MyGraphics ? (MyGraphics)((Object)g2) : null;
            return new MyGraphics(gg != null ? gg.myDelegate : g2, helper, helper.computeOffsets(g2, component), gg != null ? gg.preserved : null);
        }

        MyGraphics(Graphics g2, PaintersHelper helper, int[] offsets, Set<Color> preserved) {
            super((Graphics2D)g2);
            this.helper = helper;
            this.offsets = offsets;
            this.preserved = preserved;
        }

        @NotNull
        public Graphics create() {
            MyGraphics myGraphics = new MyGraphics(this.getDelegate().create(), this.helper, this.offsets, this.preserved);
            if (myGraphics == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/IdeBackgroundUtil$MyGraphics", "create"));
            }
            return myGraphics;
        }

        public void clearRect(int x2, int y2, int width, int height) {
            super.clearRect(x2, y2, width, height);
            this.runAllPainters(x2, y2, width, height, null, this.getColor());
        }

        public void fillRect(int x2, int y2, int width, int height) {
            super.fillRect(x2, y2, width, height);
            this.runAllPainters(x2, y2, width, height, null, this.getColor());
        }

        public void fill(Shape s2) {
            super.fill(s2);
            Rectangle r2 = s2.getBounds();
            this.runAllPainters(r2.x, r2.y, r2.width, r2.height, s2, this.getColor());
        }

        public void drawImage(BufferedImage img, BufferedImageOp op, int x2, int y2) {
            super.drawImage(img, op, x2, y2);
            this.runAllPainters(x2, y2, img.getWidth(), img.getHeight(), null, img);
        }

        public boolean drawImage(Image img, int x2, int y2, int width, int height, ImageObserver observer) {
            boolean b2 = super.drawImage(img, x2, y2, width, height, observer);
            this.runAllPainters(x2, y2, width, height, null, img);
            return b2;
        }

        public boolean drawImage(Image img, int x2, int y2, ImageObserver observer) {
            boolean b2 = super.drawImage(img, x2, y2, observer);
            this.runAllPainters(x2, y2, img.getWidth(null), img.getHeight(null), null, img);
            return b2;
        }

        @Nullable
        private Shape setTempClip(int x2, int y2, int width, int height, @Nullable Shape sourceShape) {
            Shape forcedClip;
            Shape prevClip = this.getClip();
            Shape shape = forcedClip = sourceShape != null ? sourceShape : new Rectangle(x2, y2, width, height);
            if (prevClip == null) {
                this.setClip(forcedClip);
            } else if (prevClip instanceof Rectangle2D && forcedClip instanceof Rectangle2D) {
                this.setClip(((Rectangle2D)prevClip).createIntersection((Rectangle2D)forcedClip));
            } else {
                Area area = new Area(prevClip);
                area.intersect(new Area(forcedClip));
                this.setClip(area);
            }
            return prevClip;
        }

        void runAllPainters(int x2, int y2, int width, int height, @Nullable Shape sourceShape, @Nullable Object reason) {
            boolean preserve;
            if (width <= 1 || height <= 1) {
                return;
            }
            if (reason instanceof Color && ((Color)reason).getAlpha() < 255) {
                return;
            }
            if (reason instanceof Image) {
                if (!(reason instanceof BufferedImage)) {
                    return;
                }
                if (((BufferedImage)reason).getColorModel().hasAlpha()) {
                    return;
                }
            }
            boolean bl = preserve = this.preserved != null && reason instanceof Color && this.preserved.contains(reason);
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.TRUE);
            }
            Shape prevClip = this.setTempClip(x2, y2, width, height, sourceShape);
            this.helper.runAllPainters(this.myDelegate, this.offsets);
            this.setClip(prevClip);
            if (preserve) {
                this.myDelegate.setRenderingHint(ADJUST_ALPHA, Boolean.FALSE);
            }
        }
    }
}

