/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;

public class MaximizeToolWindowAction
extends AnAction
implements DumbAware {
    public MaximizeToolWindowAction() {
        super(ActionsBundle.message((String)"action.ResizeToolWindowMaximize.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        ToolWindowManager manager;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/MaximizeToolWindowAction", "actionPerformed"));
        }
        Project project2 = e2.getProject();
        if (project2 == null || project2.isDisposed()) {
            return;
        }
        ToolWindow toolWindow = (ToolWindow)e2.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow == null) {
            return;
        }
        manager.setMaximized(toolWindow, !(manager = ToolWindowManager.getInstance((Project)project2)).isMaximized(toolWindow));
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/MaximizeToolWindowAction", "update"));
        }
        e2.getPresentation().setEnabled(true);
        Project project2 = e2.getProject();
        if (project2 == null || project2.isDisposed()) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        ToolWindow toolWindow = (ToolWindow)e2.getData(PlatformDataKeys.TOOL_WINDOW);
        if (toolWindow == null) {
            e2.getPresentation().setEnabled(false);
            return;
        }
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project2);
        e2.getPresentation().setText(manager.isMaximized(toolWindow) ? ActionsBundle.message((String)"action.ResizeToolWindowMaximize.text.alternative", (Object[])new Object[0]) : ActionsBundle.message((String)"action.ResizeToolWindowMaximize.text", (Object[])new Object[0]));
    }
}

