/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.IdeFocusManagerImpl;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class ModalityHelper {
    private static final Logger LOG = Logger.getInstance(ModalityHelper.class);
    private static Method isModalBlockedMethod = null;
    private static Method getModalBlockerMethod = null;

    public static boolean isModalBlocked(Window window) {
        boolean result2 = false;
        try {
            result2 = (Boolean)isModalBlockedMethod.invoke((Object)window, new Object[0]);
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
        return result2;
    }

    public static JDialog getModalBlockerFor(Window window) {
        JDialog result2 = null;
        try {
            result2 = (JDialog)getModalBlockerMethod.invoke((Object)window, new Object[0]);
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
        return result2;
    }

    public static JDialog getBlockerForFrame(IdeFrame ideFrame) {
        if (ideFrame == null) {
            return null;
        }
        JComponent c2 = ideFrame.getComponent();
        if (c2 == null) {
            return null;
        }
        Window window = SwingUtilities.getWindowAncestor(c2);
        if (window == null) {
            return null;
        }
        if (!ModalityHelper.isModalBlocked(window)) {
            return null;
        }
        return ModalityHelper.getModalBlockerFor(window);
    }

    public static JDialog getBlockerForFocusedFrame() {
        return ModalityHelper.getBlockerForFrame(IdeFocusManagerImpl.getGlobalInstance().getLastFocusedFrame());
    }

    static {
        Class[] noParams = new Class[]{};
        try {
            isModalBlockedMethod = Window.class.getDeclaredMethod("isModalBlocked", noParams);
            getModalBlockerMethod = Window.class.getDeclaredMethod("getModalBlocker", noParams);
            isModalBlockedMethod.setAccessible(true);
            getModalBlockerMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e2) {
            LOG.error((Throwable)e2);
        }
    }
}

