/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public final class StripeButtonUI
extends MetalToggleButtonUI {
    private static final StripeButtonUI ourInstance = new StripeButtonUI();
    private static final Rectangle ourIconRect = new Rectangle();
    private static final Rectangle ourTextRect = new Rectangle();
    private static final Rectangle ourViewRect = new Rectangle();
    private static Insets ourViewInsets = JBUI.emptyInsets();

    private StripeButtonUI() {
    }

    public static ComponentUI createUI(JComponent c2) {
        return ourInstance;
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        AnchoredButton button = (AnchoredButton)c2;
        Dimension dim = super.getPreferredSize(button);
        dim.width = (int)((float)JBUI.scale((int)4) + (float)dim.width * 1.1f);
        dim.height += JBUI.scale((int)2);
        ToolWindowAnchor anchor = button.getAnchor();
        if (ToolWindowAnchor.LEFT == anchor || ToolWindowAnchor.RIGHT == anchor) {
            return new Dimension(dim.height, dim.width);
        }
        return dim;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        Icon icon;
        AnchoredButton button = (AnchoredButton)c2;
        String text2 = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text2 == null) {
            return;
        }
        FontMetrics fm = button.getFontMetrics(button.getFont());
        ourViewInsets = c2.getInsets(ourViewInsets);
        StripeButtonUI.ourViewRect.x = StripeButtonUI.ourViewInsets.left;
        StripeButtonUI.ourViewRect.y = StripeButtonUI.ourViewInsets.top;
        ToolWindowAnchor anchor = button.getAnchor();
        if (ToolWindowAnchor.RIGHT == anchor || ToolWindowAnchor.LEFT == anchor) {
            StripeButtonUI.ourViewRect.height = c2.getWidth() - (StripeButtonUI.ourViewInsets.left + StripeButtonUI.ourViewInsets.right);
            StripeButtonUI.ourViewRect.width = c2.getHeight() - (StripeButtonUI.ourViewInsets.top + StripeButtonUI.ourViewInsets.bottom);
        } else {
            StripeButtonUI.ourViewRect.height = c2.getHeight() - (StripeButtonUI.ourViewInsets.left + StripeButtonUI.ourViewInsets.right);
            StripeButtonUI.ourViewRect.width = c2.getWidth() - (StripeButtonUI.ourViewInsets.top + StripeButtonUI.ourViewInsets.bottom);
        }
        StripeButtonUI.ourIconRect.height = 0;
        StripeButtonUI.ourIconRect.width = 0;
        StripeButtonUI.ourIconRect.y = 0;
        StripeButtonUI.ourIconRect.x = 0;
        StripeButtonUI.ourTextRect.height = 0;
        StripeButtonUI.ourTextRect.width = 0;
        StripeButtonUI.ourTextRect.y = 0;
        StripeButtonUI.ourTextRect.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(c2, fm, text2, icon, button.getVerticalAlignment(), button.getHorizontalAlignment(), button.getVerticalTextPosition(), button.getHorizontalTextPosition(), ourViewRect, ourIconRect, ourTextRect, button.getText() == null ? 0 : button.getIconTextGap());
        Graphics2D g22 = (Graphics2D)g2.create();
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ButtonModel model2 = button.getModel();
        Color background = button.getBackground();
        StripeButtonUI.ourIconRect.x -= JBUI.scale((int)2);
        StripeButtonUI.ourTextRect.x -= JBUI.scale((int)2);
        boolean off = true;
        if (model2.isArmed() && model2.isPressed() || model2.isSelected() || model2.isRollover()) {
            boolean dark;
            if (anchor == ToolWindowAnchor.LEFT) {
                g22.translate(-1, 0);
            }
            if (anchor.isHorizontal()) {
                g22.translate(0, -1);
            }
            g22.setColor((dark = UIUtil.isUnderDarcula()) ? Gray._15.withAlpha(model2.isSelected() ? 85 : 40) : Gray._85.withAlpha(model2.isSelected() ? 85 : 40));
            g22.fillRect(0, 0, button.getWidth(), button.getHeight());
            if (anchor == ToolWindowAnchor.LEFT) {
                g22.translate(1, 0);
            }
            if (anchor.isHorizontal()) {
                g22.translate(0, 1);
            }
        }
        AffineTransform tr = null;
        if (ToolWindowAnchor.RIGHT == anchor || ToolWindowAnchor.LEFT == anchor) {
            tr = g22.getTransform();
            if (ToolWindowAnchor.RIGHT == anchor) {
                if (icon != null) {
                    icon.paintIcon(c2, g22, StripeButtonUI.ourIconRect.y, StripeButtonUI.ourIconRect.x);
                }
                g22.rotate(1.5707963267948966);
                g22.translate(0, -c2.getWidth());
            } else {
                if (icon != null) {
                    icon.paintIcon(c2, g22, StripeButtonUI.ourIconRect.y, c2.getHeight() - StripeButtonUI.ourIconRect.x - icon.getIconHeight());
                }
                g22.rotate(-1.5707963267948966);
                g22.translate(-c2.getHeight(), 0);
            }
        } else if (icon != null) {
            icon.paintIcon(c2, g22, StripeButtonUI.ourIconRect.x, StripeButtonUI.ourIconRect.y);
        }
        UISettings.setupAntialiasing((Graphics)g22);
        if (text2 != null) {
            if (model2.isEnabled()) {
                if (model2.isArmed() && model2.isPressed() || model2.isSelected()) {
                    g22.setColor(background);
                } else {
                    g22.setColor(button.getForeground());
                }
            } else {
                g22.setColor(background.darker());
            }
            if (model2.isEnabled()) {
                g22.setColor(UIUtil.isUnderDarcula() && model2.isSelected() ? button.getForeground().brighter() : button.getForeground());
                BasicGraphicsUtils.drawString(g22, clippedText, button.getMnemonic2(), StripeButtonUI.ourTextRect.x, StripeButtonUI.ourTextRect.y + fm.getAscent());
            } else {
                if (model2.isSelected()) {
                    g22.setColor(c2.getBackground());
                } else {
                    g22.setColor(this.getDisabledTextColor());
                }
                BasicGraphicsUtils.drawString(g22, clippedText, button.getMnemonic2(), StripeButtonUI.ourTextRect.x, StripeButtonUI.ourTextRect.y + fm.getAscent());
            }
        }
        if (ToolWindowAnchor.RIGHT == anchor || ToolWindowAnchor.LEFT == anchor) {
            g22.setTransform(tr);
        }
        g22.dispose();
    }
}

