/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;

final class Surface
extends JComponent {
    private final Image myTopImage;
    private final Image myBottomImage;
    private final int myDirection;
    private final int myDesiredTimeToComplete;
    private final ToolWindowAnchor myAnchor;
    private int myOffset = 0;

    public Surface(Image topImage, Image bottomImage, int direction, ToolWindowAnchor anchor, int desiredTimeToComplete) {
        this.myTopImage = topImage;
        this.myBottomImage = bottomImage;
        this.myAnchor = anchor;
        this.myDirection = direction;
        this.myDesiredTimeToComplete = desiredTimeToComplete;
        this.setOpaque(true);
    }

    public final void runMovement() {
        if (!this.isShowing()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        int distance = this.myAnchor == ToolWindowAnchor.LEFT || this.myAnchor == ToolWindowAnchor.RIGHT ? bounds.width : bounds.height;
        int count = 0;
        this.myOffset = 0;
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        long startTime = System.currentTimeMillis();
        while (true) {
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            long timeSpent = System.currentTimeMillis() - startTime;
            ++count;
            if (timeSpent >= (long)this.myDesiredTimeToComplete) break;
            double onePaintTime = (double)timeSpent / (double)count;
            int iterations = (int)((double)((long)this.myDesiredTimeToComplete - timeSpent) / onePaintTime);
            iterations = Math.max(1, iterations);
            this.myOffset += (distance - this.myOffset) / iterations;
        }
    }

    @Override
    public final void paint(Graphics g2) {
        Rectangle bounds = this.getBounds();
        if (this.myAnchor == ToolWindowAnchor.LEFT) {
            if (this.myDirection == 1) {
                g2.setClip(null);
                g2.clipRect(this.myOffset, 0, bounds.width - this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(0, 0, this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)(this.myOffset - bounds.width), (int)0, null);
            } else {
                g2.setClip(null);
                g2.clipRect(bounds.width - this.myOffset, 0, this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(0, 0, bounds.width - this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)(-this.myOffset), (int)0, null);
            }
            this.myTopImage.flush();
        } else if (this.myAnchor == ToolWindowAnchor.RIGHT) {
            if (this.myDirection == 1) {
                g2.setClip(null);
                g2.clipRect(0, 0, bounds.width - this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(bounds.width - this.myOffset, 0, this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)(bounds.width - this.myOffset), (int)0, null);
            } else {
                g2.setClip(null);
                g2.clipRect(0, 0, this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(this.myOffset, 0, bounds.width - this.myOffset, bounds.height);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)this.myOffset, (int)0, null);
            }
        } else if (this.myAnchor == ToolWindowAnchor.TOP) {
            if (this.myDirection == 1) {
                g2.setClip(null);
                g2.clipRect(0, this.myOffset, bounds.width, bounds.height - this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(0, 0, bounds.width, this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)0, (int)(-bounds.height + this.myOffset), null);
            } else {
                g2.setClip(null);
                g2.clipRect(0, bounds.height - this.myOffset, bounds.width, this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(0, 0, bounds.width, bounds.height - this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)0, (int)(-this.myOffset), null);
            }
        } else if (this.myAnchor == ToolWindowAnchor.BOTTOM) {
            if (this.myDirection == 1) {
                g2.setClip(null);
                g2.clipRect(0, 0, bounds.width, bounds.height - this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(0, bounds.height - this.myOffset, bounds.width, this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)0, (int)(bounds.height - this.myOffset), null);
            } else {
                g2.setClip(null);
                g2.clipRect(0, 0, bounds.width, this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myBottomImage, (int)0, (int)0, null);
                g2.setClip(null);
                g2.clipRect(0, this.myOffset, bounds.width, bounds.height - this.myOffset);
                UIUtil.drawImage((Graphics)g2, (Image)this.myTopImage, (int)0, (int)this.myOffset, null);
            }
        }
    }
}

