/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NonNls;

public abstract class VisibilityWatcher
extends ComponentAdapter
implements PropertyChangeListener {
    @NonNls
    protected static final String ANCESTOR_PROPERTY_NAME = "ancestor";

    @Override
    public final void componentHidden(ComponentEvent e2) {
        this.visibilityChanged();
    }

    @Override
    public final void componentShown(ComponentEvent e2) {
        this.visibilityChanged();
    }

    @Override
    public final void propertyChange(PropertyChangeEvent e2) {
        if (!ANCESTOR_PROPERTY_NAME.equals(e2.getPropertyName())) {
            throw new IllegalArgumentException("unknown propertyName: " + e2.getPropertyName());
        }
        Component oldAncestor = (Component)e2.getOldValue();
        this.deinstall(oldAncestor);
        Component newAncestor = (Component)e2.getNewValue();
        this.install(newAncestor);
        this.visibilityChanged();
    }

    public final void install(Component component) {
        while (component != null) {
            component.removePropertyChangeListener(ANCESTOR_PROPERTY_NAME, this);
            component.addPropertyChangeListener(ANCESTOR_PROPERTY_NAME, this);
            component.removeComponentListener(this);
            component.addComponentListener(this);
            component = component.getParent();
        }
    }

    public void deinstall(Component component) {
        while (component != null) {
            component.removePropertyChangeListener(ANCESTOR_PROPERTY_NAME, this);
            component.removeComponentListener(this);
            component = component.getParent();
        }
    }

    public abstract void visibilityChanged();
}

