/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.commands;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowWatcher;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class RequestFocusInToolWindowCmd
extends FinalizableCommand {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.commands.RequestFocusInToolWindowCmd");
    private final ToolWindowImpl myToolWindow;
    private final FocusWatcher myFocusWatcher;
    private final Project myProject;
    private final Expirable myTimestamp;

    public RequestFocusInToolWindowCmd(IdeFocusManager focusManager, ToolWindowImpl toolWindow, FocusWatcher focusWatcher, Runnable finishCallBack, Project project2) {
        super(finishCallBack);
        this.myToolWindow = toolWindow;
        this.myFocusWatcher = focusWatcher;
        this.myProject = project2;
        this.myTimestamp = focusManager.getTimestamp(true);
    }

    @Override
    public final void run() {
        this.myToolWindow.getActivation().doWhenDone(() -> this.processRequestFocus());
    }

    private void processRequestFocus() {
        try {
            Component preferredFocusedComponent;
            if (this.myTimestamp.isExpired()) {
                return;
            }
            Component component = preferredFocusedComponent = this.myToolWindow.isUseLastFocusedOnActivation() ? this.myFocusWatcher.getFocusedComponent() : null;
            if (preferredFocusedComponent == null && this.myToolWindow.getContentManager().getSelectedContent() != null && (preferredFocusedComponent = this.myToolWindow.getContentManager().getSelectedContent().getPreferredFocusableComponent()) != null) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent == null && (preferredFocusedComponent = this.myFocusWatcher.getNearestFocusableComponent()) instanceof JComponent) {
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)preferredFocusedComponent);
            }
            if (preferredFocusedComponent != null && !preferredFocusedComponent.isShowing()) {
                preferredFocusedComponent = null;
            }
            if (preferredFocusedComponent == null) {
                JComponent component2 = this.myToolWindow.getComponent();
                preferredFocusedComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2);
            }
            if (preferredFocusedComponent != null) {
                this.requestFocus(preferredFocusedComponent).doWhenDone(() -> this.bringOwnerToFront());
            } else {
                JComponent componentToFocus = this.myToolWindow.getComponent();
                this.requestFocus(componentToFocus).doWhenDone(() -> this.bringOwnerToFront());
            }
        }
        finally {
            this.finish();
        }
    }

    private void bringOwnerToFront() {
        Window activeWindow;
        Window owner = SwingUtilities.getWindowAncestor(this.myToolWindow.getComponent());
        Window activeFrame = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (activeFrame != null && activeFrame != owner) {
            return;
        }
        if (owner != null && owner.getFocusOwner() == null && ((activeWindow = RequestFocusInToolWindowCmd.getActiveWindow(owner.getOwnedWindows())) == null || activeWindow instanceof FloatingDecorator)) {
            LOG.debug("owner.toFront()");
            owner.toFront();
        }
    }

    @NotNull
    private ActionCallback requestFocus(final @NotNull Component c2) {
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd", "requestFocus"));
        }
        final ActionCallback result2 = new ActionCallback();
        final Alarm checkerAlarm = new Alarm((Disposable)result2);
        Runnable checker = new Runnable(){
            final long startTime = System.currentTimeMillis();

            @Override
            public void run() {
                if (System.currentTimeMillis() - this.startTime > 10000L) {
                    result2.setRejected();
                    return;
                }
                if (c2.isShowing()) {
                    Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                    if (owner != null && owner == c2) {
                        RequestFocusInToolWindowCmd.this.myManager.getFocusManager().requestFocus(new FocusCommand(){

                            @NotNull
                            public ActionCallback run() {
                                ActionCallback actionCallback = ActionCallback.DONE;
                                if (actionCallback == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd$1$1", "run"));
                                }
                                return actionCallback;
                            }
                        }, false).doWhenProcessed(() -> {
                            if (c2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd$1", "lambda$run$0"));
                            }
                            RequestFocusInToolWindowCmd.this.updateToolWindow(c2);
                        }).notify(result2);
                    } else {
                        RequestFocusInToolWindowCmd.this.myManager.getFocusManager().requestFocus((FocusCommand)new FocusCommand.ByComponent(c2, (Component)RequestFocusInToolWindowCmd.this.myToolWindow.getComponent(), RequestFocusInToolWindowCmd.this.myProject, (Throwable)new Exception()), false).doWhenProcessed(() -> {
                            if (c2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd$1", "lambda$run$1"));
                            }
                            RequestFocusInToolWindowCmd.this.updateToolWindow(c2);
                        }).notify(result2);
                    }
                } else {
                    checkerAlarm.addRequest((Runnable)this, 100);
                }
            }
        };
        checkerAlarm.addRequest(checker, 0);
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/commands/RequestFocusInToolWindowCmd", "requestFocus"));
        }
        return actionCallback;
    }

    private void updateToolWindow(Component c2) {
        if (c2.isFocusOwner()) {
            this.myFocusWatcher.setFocusedComponentImpl(c2);
            if (this.myToolWindow.isAvailable() && !this.myToolWindow.isActive()) {
                this.myToolWindow.activate(null, true, false);
            }
        }
        RequestFocusInToolWindowCmd.updateFocusedComponentForWatcher(c2);
    }

    private static void updateFocusedComponentForWatcher(Component c2) {
        WindowWatcher watcher = ((WindowManagerImpl)WindowManager.getInstance()).getWindowWatcher();
        FocusWatcher focusWatcher = watcher.getFocusWatcherFor(c2);
        if (focusWatcher != null && c2.isFocusOwner()) {
            focusWatcher.setFocusedComponentImpl(c2);
        }
    }

    private static Window getActiveWindow(Window[] windows) {
        for (Window window : windows) {
            if (window.isShowing() && window.isActive()) {
                return window;
            }
            if ((window = RequestFocusInToolWindowCmd.getActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }
}

