/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.WatermarkIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import javax.swing.JLabel;
import sun.swing.SwingUtilities2;

public class BaseLabel
extends JLabel {
    protected ToolWindowContentUi myUi;
    private Color myActiveFg;
    private Color myPassiveFg;
    private boolean myBold;

    public BaseLabel(ToolWindowContentUi ui, boolean bold) {
        this.myUi = ui;
        this.setOpaque(false);
        this.myBold = bold;
    }

    @Override
    public void updateUI() {
        this.setActiveFg(JBColor.foreground());
        this.setPassiveFg((Color)new JBColor((Color)Gray._75, UIUtil.getLabelDisabledForeground()));
        super.updateUI();
    }

    @Override
    public Font getFont() {
        Font f2 = UIUtil.getLabelFont();
        f2 = f2.deriveFont(f2.getStyle(), Math.max(11, f2.getSize() - 2));
        if (this.myBold) {
            f2 = f2.deriveFont(1);
        }
        return f2;
    }

    public static Font getLabelFont() {
        Font f2 = UIUtil.getLabelFont();
        return f2.deriveFont(f2.getStyle(), Math.max(11, f2.getSize() - 2));
    }

    public void setActiveFg(Color fg) {
        this.myActiveFg = fg;
    }

    public void setPassiveFg(Color passiveFg) {
        this.myPassiveFg = passiveFg;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Color fore = this.myUi.myWindow.isActive() ? this.myActiveFg : this.myPassiveFg;
        this.setForeground(fore);
        this.putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, AntialiasingType.getAAHintForSwingComponent());
        super.paintComponent(this._getGraphics((Graphics2D)g2));
    }

    protected Graphics _getGraphics(Graphics2D g2) {
        if (!this.allowEngravement()) {
            return g2;
        }
        Color foreground = this.getForeground();
        if (Color.BLACK.equals(foreground)) {
            return new EngravedTextGraphics(g2);
        }
        return g2;
    }

    protected boolean allowEngravement() {
        return true;
    }

    protected Color getActiveFg(boolean selected) {
        return this.myActiveFg;
    }

    protected Color getPassiveFg(boolean selected) {
        return this.myPassiveFg;
    }

    protected void updateTextAndIcon(Content content2, boolean isSelected) {
        if (content2 == null) {
            this.setText(null);
            this.setIcon(null);
        } else {
            this.setText(content2.getDisplayName());
            this.setActiveFg(this.getActiveFg(isSelected));
            this.setPassiveFg(this.getPassiveFg(isSelected));
            this.setToolTipText(content2.getDescription());
            boolean show2 = Boolean.TRUE.equals(content2.getUserData(ToolWindow.SHOW_CONTENT_ICON));
            if (show2) {
                if (isSelected) {
                    this.setIcon(content2.getIcon());
                } else {
                    this.setIcon((Icon)(content2.getIcon() != null ? new WatermarkIcon(content2.getIcon(), 0.5f) : null));
                }
            } else {
                this.setIcon(null);
            }
            this.myBold = false;
        }
    }

    public Content getContent() {
        return null;
    }
}

