/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.MoreIcon;
import com.intellij.openapi.wm.impl.content.TabbedContentTabLabel;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.TabbedContent;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.Nullable;

class TabContentLayout
extends ContentLayout {
    static final int MORE_ICON_BORDER = 6;
    LayoutData myLastLayout;
    JPopupMenu myPopup;
    final PopupMenuListener myPopupListener;
    ArrayList<ContentTabLabel> myTabs = new ArrayList();
    final Map<Content, ContentTabLabel> myContent2Tabs = new HashMap<Content, ContentTabLabel>();
    private Map<String, BufferedImage> myCached = new com.intellij.util.containers.HashMap();
    private final MoreIcon myMoreIcon = new MoreIcon(){

        @Override
        protected Rectangle getIconRec() {
            return TabContentLayout.this.myLastLayout.moreRect;
        }

        @Override
        protected boolean isActive() {
            return TabContentLayout.this.myUi.myWindow.isActive();
        }

        @Override
        protected int getIconY(Rectangle iconRec) {
            return iconRec.height / 2 - this.getIconHeight() / 2;
        }
    };

    TabContentLayout(ToolWindowContentUi ui) {
        super(ui);
        this.myPopupListener = new MyPopupListener();
        new BaseButtonBehavior(this.myUi){

            protected void execute(MouseEvent e2) {
                Rectangle moreRect;
                if (!TabContentLayout.this.myUi.isCurrent(TabContentLayout.this)) {
                    return;
                }
                if (TabContentLayout.this.myLastLayout != null && (moreRect = TabContentLayout.this.myLastLayout.moreRect) != null && moreRect.contains(e2.getPoint())) {
                    TabContentLayout.this.showPopup();
                }
            }
        };
    }

    @Override
    public void init() {
        this.reset();
        this.myIdLabel = new BaseLabel(this.myUi, false){

            @Override
            protected boolean allowEngravement() {
                return this.myUi.myWindow.isActive();
            }
        };
        for (int i2 = 0; i2 < this.myUi.myManager.getContentCount(); ++i2) {
            this.contentAdded(new ContentManagerEvent((Object)this, this.myUi.myManager.getContent(i2), i2));
        }
    }

    @Override
    public void reset() {
        this.myTabs.clear();
        this.myContent2Tabs.clear();
        this.myIdLabel = null;
    }

    private void showPopup() {
        this.myPopup = new JBPopupMenu();
        this.myPopup.addPopupMenuListener(this.myPopupListener);
        ArrayList<ContentTabLabel> tabs = this.myTabs;
        for (final ContentTabLabel each : tabs) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(each.getText());
            if (this.myUi.myManager.isSelected(each.myContent)) {
                item.setSelected(true);
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    TabContentLayout.this.myUi.myManager.setSelectedContent(each.myContent, true);
                }
            });
            this.myPopup.add(item);
        }
        this.myPopup.show(this.myUi, this.myLastLayout.moreRect.x, this.myLastLayout.moreRect.y);
    }

    @Override
    public void layout() {
        Rectangle bounds = this.myUi.getBounds();
        ContentManager manager = this.myUi.myManager;
        LayoutData data = new LayoutData(this.myUi);
        data.eachX = 2;
        data.eachY = 0;
        if (this.isIdVisible()) {
            this.myIdLabel.setBounds(data.eachX, data.eachY, this.myIdLabel.getPreferredSize().width, bounds.height);
            data.eachX += this.myIdLabel.getPreferredSize().width;
        }
        int tabsStart = data.eachX;
        if (manager.getContentCount() == 0) {
            return;
        }
        Content selected = manager.getSelectedContent();
        if (selected == null) {
            selected = manager.getContents()[0];
        }
        if (this.myLastLayout != null && this.myLastLayout.layoutSize.equals(bounds.getSize()) && this.myLastLayout.contentCount == manager.getContentCount()) {
            for (ContentTabLabel each : this.myTabs) {
                if (!each.isValid()) break;
                if (each.myContent != selected || each.getBounds().width == 0) continue;
                data = this.myLastLayout;
                data.fullLayout = false;
            }
        }
        if (data.fullLayout) {
            for (ContentTabLabel eachTab : this.myTabs) {
                Dimension eachSize = eachTab.getPreferredSize();
                data.requiredWidth += eachSize.width;
                ++data.requiredWidth;
                data.toLayout.add(eachTab);
            }
            data.moreRectWidth = this.myMoreIcon.getIconWidth() + 12;
            data.toFitWidth = bounds.getSize().width - data.eachX;
            ContentTabLabel selectedTab = this.myContent2Tabs.get(selected);
            while (data.requiredWidth > data.toFitWidth && data.toLayout.size() > 1) {
                if (data.toLayout.get(0) != selectedTab) {
                    TabContentLayout.dropTab(data, data.toLayout.remove(0));
                    continue;
                }
                if (data.toLayout.get(data.toLayout.size() - 1) == selectedTab) break;
                TabContentLayout.dropTab(data, data.toLayout.remove(data.toLayout.size() - 1));
            }
            boolean reachedBounds = false;
            data.moreRect = null;
            for (ContentTabLabel each : data.toLayout) {
                data.eachY = 0;
                Dimension eachSize = each.getPreferredSize();
                if (data.eachX + eachSize.width < data.toFitWidth + tabsStart) {
                    each.setBounds(data.eachX, data.eachY, eachSize.width, bounds.height - data.eachY);
                    data.eachX += eachSize.width;
                    continue;
                }
                if (!reachedBounds) {
                    int width = bounds.width - data.eachX - data.moreRectWidth;
                    each.setBounds(data.eachX, data.eachY, width, bounds.height - data.eachY);
                    data.eachX += width;
                } else {
                    each.setBounds(0, 0, 0, 0);
                }
                reachedBounds = true;
            }
            for (ContentTabLabel each : data.toDrop) {
                each.setBounds(0, 0, 0, 0);
            }
        }
        if (data.toDrop.size() > 0) {
            data.moreRect = new Rectangle(data.eachX + 6, 0, this.myMoreIcon.getIconWidth(), bounds.height);
            int selectedIndex = manager.getIndexOfContent(manager.getSelectedContent());
            if (selectedIndex == 0) {
                this.myMoreIcon.setPaintedIcons(false, true);
            } else if (selectedIndex == manager.getContentCount() - 1) {
                this.myMoreIcon.setPaintedIcons(true, false);
            } else {
                this.myMoreIcon.setPaintedIcons(true, true);
            }
        } else {
            data.moreRect = null;
        }
        this.myLastLayout = data;
    }

    @Override
    public int getMinimumWidth() {
        int result2 = 0;
        if (this.myIdLabel != null) {
            result2 += this.myIdLabel.getPreferredSize().width;
            Insets insets = this.myIdLabel.getInsets();
            if (insets != null) {
                result2 += insets.left + insets.right;
            }
        }
        if (this.myLastLayout != null) {
            result2 += this.myLastLayout.moreRectWidth + this.myLastLayout.requiredWidth;
            result2 -= this.myLastLayout.toLayout.size() > 1 ? this.myLastLayout.moreRectWidth + 1 : -14;
        }
        return result2;
    }

    static void dropTab(LayoutData data, ContentTabLabel toDropLabel) {
        data.requiredWidth -= toDropLabel.getPreferredSize().width + 1;
        data.toDrop.add(toDropLabel);
        if (data.toDrop.size() == 1) {
            data.toFitWidth -= data.moreRectWidth;
        }
    }

    boolean isToDrawTabs() {
        return this.myTabs.size() > 1;
    }

    @Override
    public void paintComponent(Graphics g2) {
        if (!this.isToDrawTabs()) {
            return;
        }
        boolean prevSelected = false;
        for (int i2 = 0; i2 < this.myTabs.size(); ++i2) {
            BufferedImage image;
            boolean last = i2 == this.myTabs.size() - 1 || i2 + 1 < this.myTabs.size() && this.myTabs.get((int)(i2 + 1)).getBounds().width == 0;
            ContentTabLabel each = this.myTabs.get(i2);
            Rectangle r2 = each.getBounds();
            StringBuilder key = new StringBuilder().append(i2);
            if (each.isSelected()) {
                key.append('s');
            }
            if (prevSelected) {
                key.append('p');
            }
            if (last) {
                key.append('l');
            }
            if (this.myUi.myWindow.isActive()) {
                key.append('a');
            }
            if ((image = this.myCached.get(key.toString())) == null || image.getWidth() != r2.width || image.getHeight() != r2.height) {
                image = TabContentLayout.drawToBuffer(r2, each.isSelected(), last, prevSelected, this.myUi.myWindow.isActive());
                this.myCached.put(key.toString(), image);
            }
            if (image != null) {
                UIUtil.drawImage((Graphics)g2, (Image)image, (int)(this.isIdVisible() ? r2.x : r2.x - 2), (int)r2.y, null);
            }
            prevSelected = each.isSelected();
        }
    }

    @Nullable
    private static BufferedImage drawToBuffer(Rectangle r2, boolean selected, boolean last, boolean prevSelected, boolean active2) {
        if (r2.width <= 0 || r2.height <= 0) {
            return null;
        }
        BufferedImage image = UIUtil.createImage((int)r2.width, (int)r2.height, (int)2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (selected) {
            if (!UIUtil.isUnderDarcula()) {
                g2d.setColor(active2 ? new Color(0, 0, 0, 70) : new Color(0, 0, 0, 90));
                g2d.fillRect(0, 0, r2.width, r2.height);
                g2d.setColor(new Color(0, 0, 0, 140));
                g2d.drawLine(0, 0, r2.width - 1, 0);
                g2d.drawLine(0, 1, 0, r2.height - 1);
                g2d.setColor(new Color(0, 0, 0, 20));
                g2d.drawLine(1, 1, r2.width - 1, 1);
                g2d.drawLine(1, 2, 1, r2.height - 2);
                g2d.drawLine(1, r2.height - 1, r2.width - 1, r2.height - 1);
                g2d.setColor(new Color(0, 0, 0, 60));
                g2d.drawLine(r2.width - 1, 1, r2.width - 1, r2.height - 2);
            }
            if (active2) {
                g2d.setColor(new Color(100, 150, 230, 50));
                g2d.fill(new Rectangle(0, 0, r2.width, r2.height));
            }
        } else {
            g2d.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new Color(0, 0, 0, 10), (float)0.0f, (float)r2.height, (Color)new Color(0, 0, 0, 30)));
            g2d.fillRect(0, 0, r2.width, r2.height);
            Color c2 = new Color(255, 255, 255, UIUtil.isUnderDarcula() ? 10 : 80);
            if (last) {
                if (prevSelected) {
                    g2d.setColor(c2);
                    g2d.drawRect(0, 0, r2.width - 2, r2.height - 1);
                } else {
                    g2d.setColor(c2);
                    g2d.drawRect(1, 0, r2.width - 3, r2.height - 1);
                    g2d.setColor(new Color(0, 0, 0, 60));
                    g2d.drawLine(0, 0, 0, r2.height);
                }
                g2d.setColor(new Color(0, 0, 0, 60));
                g2d.drawLine(r2.width - 1, 0, r2.width - 1, r2.height);
            } else if (prevSelected) {
                g2d.setColor(c2);
                g2d.drawRect(0, 0, r2.width - 1, r2.height - 1);
            } else {
                g2d.setColor(c2);
                g2d.drawRect(1, 0, r2.width - 2, r2.height - 1);
                g2d.setColor(new Color(0, 0, 0, 60));
                g2d.drawLine(0, 0, 0, r2.height);
            }
        }
        g2d.dispose();
        return image;
    }

    @Override
    public void paintChildren(Graphics g2) {
        if (!this.isToDrawTabs()) {
            return;
        }
        if (this.myLastLayout != null && this.myLastLayout.moreRect != null) {
            this.myMoreIcon.paintIcon(this.myUi, g2);
        }
    }

    @Override
    public void update() {
        for (ContentTabLabel each : this.myTabs) {
            each.update();
        }
        this.updateIdLabel(this.myIdLabel);
    }

    @Override
    public void rebuild() {
        this.myUi.removeAll();
        this.myUi.add(this.myIdLabel);
        ToolWindowContentUi.initMouseListeners(this.myIdLabel, this.myUi);
        for (ContentTabLabel each : this.myTabs) {
            this.myUi.add(each);
            ToolWindowContentUi.initMouseListeners(each, this.myUi);
        }
        this.myCached.clear();
    }

    @Override
    public void contentAdded(ContentManagerEvent event) {
        Content content2 = event.getContent();
        ContentTabLabel tab = content2 instanceof TabbedContent ? new TabbedContentTabLabel((TabbedContent)content2, this) : new ContentTabLabel(content2, this);
        this.myTabs.add(event.getIndex(), tab);
        this.myContent2Tabs.put(content2, tab);
        if (content2 instanceof DnDTarget) {
            DnDTarget target = (DnDTarget)content2;
            DnDSupport.createBuilder((JComponent)tab).setDropHandler((DnDDropHandler)target).setTargetChecker((DnDTargetChecker)target).install();
        }
        this.myCached.clear();
    }

    @Override
    public void contentRemoved(ContentManagerEvent event) {
        ContentTabLabel tab = this.myContent2Tabs.get(event.getContent());
        if (tab != null) {
            this.myTabs.remove(tab);
            this.myContent2Tabs.remove(event.getContent());
        }
        this.myCached.clear();
    }

    @Override
    public boolean shouldDrawDecorations() {
        return this.isToDrawTabs();
    }

    @Override
    public void showContentPopup(ListPopup listPopup) {
        Content selected = this.myUi.myManager.getSelectedContent();
        if (selected != null) {
            ContentTabLabel tab = this.myContent2Tabs.get(selected);
            listPopup.showUnderneathOf((Component)tab);
        } else {
            listPopup.showUnderneathOf((Component)this.myIdLabel);
        }
    }

    @Override
    public RelativeRectangle getRectangleFor(Content content2) {
        ContentTabLabel label = this.myContent2Tabs.get(content2);
        return new RelativeRectangle((Component)label.getParent(), label.getBounds());
    }

    @Override
    public Component getComponentFor(Content content2) {
        return this.myContent2Tabs.get(content2);
    }

    @Override
    public String getCloseActionName() {
        return UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
    }

    @Override
    public String getCloseAllButThisActionName() {
        return UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
    }

    @Override
    public String getPreviousContentActionName() {
        return "Select Previous Tab";
    }

    @Override
    public String getNextContentActionName() {
        return "Select Next Tab";
    }

    static class LayoutData {
        int toFitWidth;
        int requiredWidth;
        Dimension layoutSize;
        boolean fullLayout = true;
        int moreRectWidth;
        ArrayList<ContentTabLabel> toLayout = new ArrayList();
        ArrayList<ContentTabLabel> toDrop = new ArrayList();
        Rectangle moreRect;
        public int eachX;
        public int eachY;
        public int contentCount;

        LayoutData(ToolWindowContentUi ui) {
            this.layoutSize = ui.getSize();
            this.contentCount = ui.myManager.getContentCount();
        }
    }

    private class MyPopupListener
    implements PopupMenuListener {
        private MyPopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
            if (TabContentLayout.this.myPopup != null) {
                TabContentLayout.this.myPopup.removePopupMenuListener(this);
            }
            TabContentLayout.this.myPopup = null;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e2) {
        }
    }
}

