/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.CloseAction;
import com.intellij.ide.actions.ShowContentAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ComboContentLayout;
import com.intellij.openapi.wm.impl.content.ContentLayout;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.util.Alarm;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolWindowContentUi
extends JPanel
implements ContentUI,
PropertyChangeListener,
DataProvider {
    public static final String POPUP_PLACE = "ToolwindowPopup";
    public static final String HIDE_ID_LABEL = "HideIdLabel";
    ContentManager myManager;
    final JPanel myContent = new JPanel(new BorderLayout());
    ToolWindowImpl myWindow;
    TabbedContentAction.CloseAllAction myCloseAllAction;
    TabbedContentAction.MyNextTabAction myNextTabAction;
    TabbedContentAction.MyPreviousTabAction myPreviousTabAction;
    ShowContentAction myShowContent;
    ContentLayout myTabsLayout = new TabContentLayout(this);
    ContentLayout myComboLayout = new ComboContentLayout(this);
    private ToolWindowContentUiType myType = ToolWindowContentUiType.TABBED;
    private boolean myShouldNotShowPopup;

    public ToolWindowContentUi(ToolWindowImpl window) {
        this.myWindow = window;
        this.myContent.setOpaque(false);
        this.myContent.setFocusable(false);
        this.setOpaque(false);
        this.myShowContent = new ShowContentAction(this.myWindow, this.myContent);
        this.setBorder(new EmptyBorder(0, 0, 0, 2));
    }

    public void setType(@NotNull ToolWindowContentUiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "setType"));
        }
        if (this.myType != type) {
            if (this.myType != null) {
                this.getCurrentLayout().reset();
            }
            this.myType = type;
            this.getCurrentLayout().init();
            this.rebuild();
        }
    }

    private ContentLayout getCurrentLayout() {
        assert (this.myManager != null);
        return this.myType == ToolWindowContentUiType.TABBED ? this.myTabsLayout : this.myComboLayout;
    }

    public JComponent getComponent() {
        return this.myContent;
    }

    public JComponent getTabComponent() {
        return this;
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "setManager"));
        }
        if (this.myManager != null) {
            this.getCurrentLayout().reset();
        }
        this.myManager = manager;
        this.getCurrentLayout().init();
        this.myManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(ContentManagerEvent event) {
                ToolWindowContentUi.this.getCurrentLayout().contentAdded(event);
                event.getContent().addPropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoved(ContentManagerEvent event) {
                event.getContent().removePropertyChangeListener((PropertyChangeListener)ToolWindowContentUi.this);
                ToolWindowContentUi.this.getCurrentLayout().contentRemoved(event);
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.rebuild();
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
            }

            public void selectionChanged(ContentManagerEvent event) {
                ToolWindowContentUi.this.ensureSelectedContentVisible();
                ToolWindowContentUi.this.update();
                ToolWindowContentUi.this.myContent.revalidate();
                ToolWindowContentUi.this.myContent.repaint();
            }
        });
        ToolWindowContentUi.initMouseListeners(this, this);
        this.rebuild();
        this.myCloseAllAction = new TabbedContentAction.CloseAllAction(this.myManager);
        this.myNextTabAction = new TabbedContentAction.MyNextTabAction(this.myManager);
        this.myPreviousTabAction = new TabbedContentAction.MyPreviousTabAction(this.myManager);
    }

    private void ensureSelectedContentVisible() {
        Component visible;
        Content selected = this.myManager.getSelectedContent();
        if (selected == null) {
            this.myContent.removeAll();
            return;
        }
        if (this.myContent.getComponentCount() == 1 && (visible = this.myContent.getComponent(0)) == selected.getComponent()) {
            return;
        }
        this.myContent.removeAll();
        this.myContent.add((Component)selected.getComponent(), "Center");
        this.myContent.revalidate();
        this.myContent.repaint();
    }

    private void rebuild() {
        this.getCurrentLayout().rebuild();
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
        if (this.myManager.getContentCount() == 0 && this.myWindow.isToHideOnEmptyContent()) {
            this.myWindow.hide(null);
        }
    }

    @Override
    public void doLayout() {
        this.getCurrentLayout().layout();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.getCurrentLayout().paintComponent(g2);
    }

    @Override
    protected void paintChildren(Graphics g2) {
        super.paintChildren(g2);
        this.getCurrentLayout().paintChildren(g2);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        return new Dimension(insets.left + insets.right + this.getCurrentLayout().getMinimumWidth(), super.getMinimumSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component each = this.getComponent(i2);
            size.height = Math.max(each.getPreferredSize().height, size.height);
        }
        return size;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    private void update() {
        this.getCurrentLayout().update();
        this.revalidate();
        this.repaint();
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public void beforeDispose() {
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "canChangeSelectionTo"));
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string2 = this.getCurrentLayout().getCloseActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getCloseActionName"));
        }
        return string2;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string2 = this.getCurrentLayout().getCloseAllButThisActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getCloseAllButThisActionName"));
        }
        return string2;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string2 = this.getCurrentLayout().getPreviousContentActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getPreviousContentActionName"));
        }
        return string2;
    }

    @NotNull
    public String getNextContentActionName() {
        String string2 = this.getCurrentLayout().getNextContentActionName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi", "getNextContentActionName"));
        }
        return string2;
    }

    public static void initMouseListeners(final JComponent c2, final ToolWindowContentUi ui) {
        if (c2.getClientProperty(ui) != null) {
            return;
        }
        final Point[] myLastPoint = new Point[1];
        c2.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                if (myLastPoint[0] == null) {
                    return;
                }
                Window window = SwingUtilities.windowForComponent(c2);
                if (window instanceof IdeFrame) {
                    return;
                }
                Point windowLocation = window.getLocationOnScreen();
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info == null) {
                    return;
                }
                Point newPoint = info.getLocation();
                Point p2 = myLastPoint[0];
                windowLocation.translate(newPoint.x - p2.x, newPoint.y - p2.y);
                window.setLocation(windowLocation);
                myLastPoint[0] = newPoint;
            }
        });
        c2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                PointerInfo info = MouseInfo.getPointerInfo();
                Point point = myLastPoint[0] = info != null ? info.getLocation() : e2.getLocationOnScreen();
                if (!e2.isPopupTrigger() && !UIUtil.isCloseClick((MouseEvent)e2)) {
                    ui.myWindow.fireActivated();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                if (!e2.isPopupTrigger() && UIUtil.isCloseClick((MouseEvent)e2, (int)502)) {
                    ui.processHide(e2);
                }
            }
        });
        c2.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x2, int y2) {
                Content content2 = c2 instanceof BaseLabel ? ((BaseLabel)c2).getContent() : null;
                ui.showContextMenu(comp, x2, y2, ui.myWindow.getPopupGroup(), content2);
            }
        });
        c2.putClientProperty(ui, Boolean.TRUE);
    }

    private void initActionGroup(DefaultActionGroup group, Content content2) {
        String groupName;
        if (content2 == null) {
            return;
        }
        group.addSeparator();
        group.add((AnAction)new TabbedContentAction.CloseAction(content2));
        group.add((AnAction)this.myCloseAllAction);
        group.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content2));
        group.addSeparator();
        if (content2.isPinnable()) {
            group.add(PinToolwindowTabAction.getPinAction());
            group.addSeparator();
        }
        group.add((AnAction)this.myNextTabAction);
        group.add((AnAction)this.myPreviousTabAction);
        group.add((AnAction)this.myShowContent);
        if (content2 instanceof TabbedContent && ((TabbedContent)content2).getTabs().size() > 1) {
            group.addAction(ToolWindowContentUi.createSplitTabsAction((TabbedContent)content2));
        }
        if (Boolean.TRUE == content2.getUserData(Content.TABBED_CONTENT_KEY) && (groupName = (String)content2.getUserData(Content.TAB_GROUP_NAME_KEY)) != null) {
            group.addAction(ToolWindowContentUi.createMergeTabsAction(this.myManager, groupName));
        }
        group.addSeparator();
    }

    public void showContextMenu(Component comp, int x2, int y2, ActionGroup toolWindowGroup, @Nullable Content selectedContent) {
        if (selectedContent == null && toolWindowGroup == null) {
            return;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        if (selectedContent != null) {
            this.initActionGroup(group, selectedContent);
        }
        if (toolWindowGroup != null) {
            group.addAll(toolWindowGroup);
        }
        ActionPopupMenu popupMenu = ((ActionManagerImpl)ActionManager.getInstance()).createActionPopupMenu(POPUP_PLACE, (ActionGroup)group, new MenuItemPresentationFactory(true));
        popupMenu.getComponent().show(comp, x2, y2);
    }

    private static AnAction createSplitTabsAction(final TabbedContent content2) {
        return new DumbAwareAction("Split '" + content2.getTitlePrefix() + "' group"){

            public void actionPerformed(AnActionEvent e2) {
                content2.split();
            }
        };
    }

    private static AnAction createMergeTabsAction(final ContentManager manager, final String tabPrefix) {
        return new DumbAwareAction("Merge tabs to '" + tabPrefix + "' group"){

            public void actionPerformed(AnActionEvent e2) {
                Content selectedContent = manager.getSelectedContent();
                ArrayList<Pair> tabs = new ArrayList<Pair>();
                int selectedTab = -1;
                ArrayList mergedContent = ContainerUtil.newArrayList();
                for (Content content2 : manager.getContents()) {
                    if (!tabPrefix.equals(content2.getUserData(Content.TAB_GROUP_NAME_KEY))) continue;
                    String label = content2.getTabName().substring(tabPrefix.length() + 2);
                    JComponent component = content2.getComponent();
                    if (content2 == selectedContent) {
                        selectedTab = tabs.size();
                    }
                    tabs.add(Pair.create((Object)label, (Object)component));
                    manager.removeContent(content2, false);
                    content2.setComponent(null);
                    content2.setShouldDisposeContent(false);
                    mergedContent.add(content2);
                }
                PropertiesComponent.getInstance().unsetValue("tabbed.toolwindow.expanded." + tabPrefix);
                for (int i2 = 0; i2 < tabs.size(); ++i2) {
                    Pair tab = (Pair)tabs.get(i2);
                    ContentUtilEx.addTabbedContent(manager, (JComponent)tab.second, tabPrefix, (String)tab.first, i2 == selectedTab);
                }
                mergedContent.forEach(Disposer::dispose);
            }
        };
    }

    private void processHide(MouseEvent e2) {
        IdeEventQueue.getInstance().blockNextEvents(e2);
        Component c2 = e2.getComponent();
        if (c2 instanceof BaseLabel) {
            BaseLabel tab = (BaseLabel)c2;
            if (tab.getContent() != null) {
                if (this.myManager.canCloseContents() && tab.getContent().isCloseable()) {
                    this.myManager.removeContent(tab.getContent(), true, true, true);
                } else if (this.myManager.getContentCount() == 1) {
                    this.hideWindow(e2);
                }
            } else {
                this.hideWindow(e2);
            }
        } else {
            this.hideWindow(e2);
        }
    }

    private void hideWindow(MouseEvent e2) {
        if (e2.isControlDown()) {
            this.myWindow.fireHiddenSide();
        } else {
            this.myWindow.fireHidden();
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.TOOL_WINDOW.is(dataId)) {
            return this.myWindow;
        }
        if (CloseAction.CloseTarget.KEY.is(dataId)) {
            return this.computeCloseTarget();
        }
        return null;
    }

    private CloseAction.CloseTarget computeCloseTarget() {
        Content selected;
        if (this.myManager.canCloseContents() && (selected = this.myManager.getSelectedContent()) != null && selected.isCloseable()) {
            return new CloseContentTarget(selected);
        }
        return new HideToolwindowTarget();
    }

    public void dispose() {
    }

    boolean isCurrent(ContentLayout layout) {
        return this.getCurrentLayout() == layout;
    }

    public void toggleContentPopup() {
        if (this.myShouldNotShowPopup) {
            this.myShouldNotShowPopup = false;
            return;
        }
        Ref selected = Ref.create();
        Ref selectedTab = Ref.create();
        Content[] contents = this.myManager.getContents();
        Content selectedContent = this.myManager.getSelectedContent();
        AnAction[] actions2 = new AnAction[contents.length];
        for (int i2 = 0; i2 < actions2.length; ++i2) {
            final Content content2 = contents[i2];
            if (content2 instanceof TabbedContent) {
                final TabbedContent tabbedContent = (TabbedContent)content2;
                List tabs = ((TabbedContent)content2).getTabs();
                AnAction[] tabActions = new AnAction[tabs.size()];
                for (int j2 = 0; j2 < tabActions.length; ++j2) {
                    final int index = j2;
                    tabActions[j2] = new DumbAwareAction((String)((Pair)tabs.get((int)index)).first){

                        public void actionPerformed(@NotNull AnActionEvent e2) {
                            if (e2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$7", "actionPerformed"));
                            }
                            ToolWindowContentUi.this.myManager.setSelectedContent((Content)tabbedContent);
                            tabbedContent.selectContent(index);
                        }
                    };
                }
                DefaultActionGroup group = new DefaultActionGroup(tabActions);
                group.getTemplatePresentation().setText(((TabbedContent)content2).getTitlePrefix());
                group.setPopup(true);
                actions2[i2] = group;
                if (content2 != selectedContent) continue;
                selected.set((Object)group);
                int selectedIndex = ContentUtilEx.getSelectedTab(tabbedContent);
                if (selectedIndex == -1) continue;
                selectedTab.set((Object)tabActions[selectedIndex]);
                continue;
            }
            actions2[i2] = new DumbAwareAction(){
                {
                    this.getTemplatePresentation().setText(content2.getTabName(), false);
                }

                public void actionPerformed(@NotNull AnActionEvent e2) {
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/content/ToolWindowContentUi$8", "actionPerformed"));
                    }
                    ToolWindowContentUi.this.myManager.setSelectedContent(content2, true, true);
                }
            };
            if (content2 != selectedContent) continue;
            selected.set((Object)actions2[i2]);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(actions2), DataManager.getInstance().getDataContext((Component)this.myManager.getComponent()), false, true, true, null, -1, action2 -> action2 == selected.get() || action2 == selectedTab.get());
        this.getCurrentLayout().showContentPopup(popup2);
        if (selectedContent instanceof TabbedContent) {
            new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)popup2).addRequest(() -> popup2.handleSelect(true), 30);
        }
    }

    private class CloseContentTarget
    implements CloseAction.CloseTarget {
        private Content myContent;

        private CloseContentTarget(Content content2) {
            this.myContent = content2;
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.myManager.removeContent(this.myContent, true, true, true);
        }
    }

    private class HideToolwindowTarget
    implements CloseAction.CloseTarget {
        private HideToolwindowTarget() {
        }

        @Override
        public void close() {
            ToolWindowContentUi.this.myWindow.fireHidden();
        }
    }
}

