/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BasicStroke;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ClockPanel
extends JComponent {
    private static final int TOP = 1005;
    private static final int TOP_LEFT = 881;
    private static final int TOP_RIGHT = 927;
    private static final int MIDDLE = 892;
    private static final int BOTTOM_LEFT = 325;
    private static final int BOTTOM_RIGHT = 1019;
    private static final int BOTTOM = 877;
    protected final Calendar myCalendar;
    private final boolean is24Hours;
    private ScheduledFuture<?> myScheduledFuture;
    private final Runnable myRepaintRunnable = () -> this.repaint();

    public ClockPanel() {
        this.myCalendar = Calendar.getInstance();
        this.is24Hours = new SimpleDateFormat().toLocalizedPattern().contains("H");
    }

    private void scheduleNextRepaint() {
        if (this.myScheduledFuture != null && !this.myScheduledFuture.isDone()) {
            this.myScheduledFuture.cancel(false);
        }
        this.myCalendar.setTimeInMillis(System.currentTimeMillis());
        this.myScheduledFuture = EdtExecutorService.getScheduledExecutorInstance().schedule(this.myRepaintRunnable, (long)(60 - this.myCalendar.get(13)), TimeUnit.SECONDS);
    }

    @Override
    public Dimension getPreferredSize() {
        Container parent = this.getParent();
        int height = this.isVisible() && parent != null ? parent.getSize().height - parent.getInsets().top - parent.getInsets().bottom : super.getPreferredSize().height;
        return new Dimension((int)((double)height * 2.5), height);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics.create();
        try {
            boolean eveningDot;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            int h2 = (int)((double)this.getHeight() * 0.8);
            int w2 = h2 / 2;
            float thickness = (float)h2 * 0.1f;
            AffineTransform transform = g2.getTransform();
            if (transform == null) {
                transform = new AffineTransform(1.0f, 0.0f, -thickness / (float)h2, 1.0f, thickness * 3.0f, thickness / 4.0f);
            } else {
                transform.concatenate(new AffineTransform(1.0f, 0.0f, -thickness / (float)h2, 1.0f, thickness * 3.0f, thickness / 4.0f));
            }
            g2.setTransform(transform);
            g2.setStroke(new BasicStroke(thickness, 1, 1));
            g2.setColor(UIManager.getColor("Label.foreground"));
            this.myCalendar.setTimeInMillis(System.currentTimeMillis());
            int hours = this.myCalendar.get(this.is24Hours ? 11 : 10);
            if (hours == 0 && !this.is24Hours) {
                hours = 12;
            }
            int minutes = this.myCalendar.get(12);
            int x2 = 0;
            int y2 = (this.getHeight() - h2) / 2;
            boolean bl = eveningDot = !this.is24Hours && this.myCalendar.get(11) > 11;
            if (eveningDot) {
                g2.setStroke(new BasicStroke(thickness * 2.0f, 1, 1));
                g2.draw(new Line2D.Float((float)x2 + thickness, (float)y2 + thickness, (float)x2 + thickness, (float)y2 + thickness + thickness / 20.0f));
            }
            g2.setStroke(new BasicStroke(thickness, 1, 1));
            if (hours >= 10) {
                ClockPanel.paintDigit(g2, x2, y2, w2, h2, thickness, hours / 10);
            }
            x2 = (int)((float)x2 + ((float)w2 + thickness * 2.0f));
            ClockPanel.paintDigit(g2, x2, y2, w2, h2, thickness, hours % 10);
            x2 = (int)((float)x2 + ((float)w2 + thickness * 2.0f));
            g2.draw(new Line2D.Float(x2, (float)(y2 + h2 / 2) - thickness * 2.0f, x2, (float)(y2 + h2 / 2) - thickness * 2.0f + thickness / 20.0f));
            g2.draw(new Line2D.Float(x2, (float)(y2 + h2 / 2) + thickness * 2.0f, x2, (float)(y2 + h2 / 2) + thickness * 2.0f + thickness / 20.0f));
            x2 = (int)((float)x2 + thickness * 2.0f);
            ClockPanel.paintDigit(g2, x2, y2, w2, h2, thickness, minutes / 10);
            x2 = (int)((float)x2 + ((float)w2 + thickness * 2.0f));
            ClockPanel.paintDigit(g2, x2, y2, w2, h2, thickness, minutes % 10);
            this.scheduleNextRepaint();
        }
        finally {
            g2.dispose();
        }
    }

    private static void paintDigit(Graphics2D g2, int x2, int y2, int width, int height, float t2, int digit) {
        digit = 1 << digit;
        int h2 = height / 2;
        float t54 = t2 * 5.0f / 4.0f;
        float t34 = t2 * 3.0f / 4.0f;
        float t22 = t2 / 2.0f;
        if ((digit & 0x3ED) != 0) {
            g2.draw(new Line2D.Float((float)x2 + t54, (float)y2 + t22, (float)(x2 + width) - t54, (float)y2 + t22));
        }
        if ((digit & 0x371) != 0) {
            g2.draw(new Line2D.Float((float)x2 + t22, (float)y2 + t54, (float)x2 + t22, (float)(y2 + h2) - t34));
        }
        if ((digit & 0x39F) != 0) {
            g2.draw(new Line2D.Float((float)(x2 + width) - t22, (float)y2 + t54, (float)(x2 + width) - t22, (float)(y2 + h2) - t34));
        }
        if ((digit & 0x37C) != 0) {
            g2.draw(new Line2D.Float((float)x2 + t54, y2 + h2, (float)(x2 + width) - t54, y2 + h2));
        }
        if ((digit & 0x145) != 0) {
            g2.draw(new Line2D.Float((float)x2 + t22, (float)(y2 + h2) + t34, (float)x2 + t22, (float)(y2 + height) - t54));
        }
        if ((digit & 0x3FB) != 0) {
            g2.draw(new Line2D.Float((float)(x2 + width) - t22, (float)(y2 + h2) + t34, (float)(x2 + width) - t22, (float)(y2 + height) - t54));
        }
        if ((digit & 0x36D) != 0) {
            g2.draw(new Line2D.Float((float)x2 + t54, (float)(y2 + height) - t22, (float)(x2 + width) - t54, (float)(y2 + height) - t22));
        }
    }
}

