/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import java.awt.Component;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarUtil {
    private StatusBarUtil() {
    }

    @Nullable
    public static FileEditor getCurrentFileEditor(@NotNull Project project2, @Nullable StatusBar statusBar) {
        EditorWithProviderComposite editor;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/status/StatusBarUtil", "getCurrentFileEditor"));
        }
        if (statusBar == null) {
            return null;
        }
        DockContainer c2 = DockManager.getInstance((Project)project2).getContainerFor((Component)statusBar.getComponent());
        EditorsSplitters splitters = null;
        if (c2 instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)c2).getSplitters();
        }
        if (splitters != null && splitters.getCurrentWindow() != null && (editor = splitters.getCurrentWindow().getSelectedEditor()) != null) {
            return (FileEditor)editor.getSelectedEditorWithProvider().getFirst();
        }
        return null;
    }

    public static void setStatusBarInfo(@NotNull Project project2, @NotNull @Nls String message2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/status/StatusBarUtil", "setStatusBarInfo"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/wm/impl/status/StatusBarUtil", "setStatusBarInfo"));
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        if (statusBar != null) {
            statusBar.setInfo(message2);
        }
    }
}

