/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public abstract class WelcomePopupAction
extends AnAction
implements DumbAware {
    protected abstract void fillActions(DefaultActionGroup var1);

    protected abstract String getTextForEmpty();

    protected abstract String getCaption();

    protected abstract boolean isSilentlyChooseSingleOption();

    public void actionPerformed(AnActionEvent e2) {
        this.showPopup(e2);
    }

    private void showPopup(AnActionEvent e2) {
        final DefaultActionGroup group = new DefaultActionGroup();
        this.fillActions(group);
        if (group.getChildrenCount() == 1 && this.isSilentlyChooseSingleOption()) {
            AnAction[] children2 = group.getChildren(null);
            children2[0].actionPerformed(e2);
            return;
        }
        if (group.getChildrenCount() == 0) {
            group.add(new AnAction(this.getTextForEmpty()){

                public void actionPerformed(AnActionEvent e2) {
                    group.setPopup(false);
                }
            });
        }
        DataContext context2 = e2.getDataContext();
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(this.getCaption(), (ActionGroup)group, context2, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        JComponent contextComponent = null;
        InputEvent inputEvent = e2.getInputEvent();
        if (inputEvent instanceof MouseEvent && inputEvent.getSource() instanceof JComponent) {
            contextComponent = (JComponent)inputEvent.getSource();
        }
        this.showPopup(context2, popup2, contextComponent);
    }

    protected void showPopup(DataContext context2, ListPopup popup2, JComponent contextComponent) {
        Component focusedComponent;
        Component component = focusedComponent = contextComponent != null ? contextComponent : (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context2);
        if (focusedComponent != null) {
            if (popup2 instanceof PopupFactoryImpl.ActionGroupPopup && focusedComponent instanceof JLabel) {
                ((PopupFactoryImpl.ActionGroupPopup)popup2).showUnderneathOfLabel((JLabel)focusedComponent);
            } else {
                popup2.showUnderneathOf(focusedComponent);
            }
        } else {
            focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent((Project)null);
            Rectangle r2 = WindowManagerEx.getInstanceEx().getScreenBounds();
            int x2 = r2.x + r2.width / 2;
            int y2 = r2.y + r2.height / 2;
            Point point = new Point(x2, y2);
            SwingUtilities.convertPointToScreen(point, focusedComponent.getParent());
            popup2.showInScreenCoordinates((Component)focusedComponent.getParent(), point);
        }
    }
}

