/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.packageDependencies.BackwardDependenciesBuilder;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.packageDependencies.actions.DependenciesHandlerBase;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.HashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnalyzeDependenciesOnSpecifiedTargetHandler
extends DependenciesHandlerBase {
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Dependencies", (String)ToolWindowId.DEPENDENCIES);
    private final GlobalSearchScope myTargetScope;

    public AnalyzeDependenciesOnSpecifiedTargetHandler(@NotNull Project project2, @NotNull AnalysisScope scope, @NotNull GlobalSearchScope targetScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/actions/AnalyzeDependenciesOnSpecifiedTargetHandler", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/packageDependencies/actions/AnalyzeDependenciesOnSpecifiedTargetHandler", "<init>"));
        }
        if (targetScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetScope", "com/intellij/packageDependencies/actions/AnalyzeDependenciesOnSpecifiedTargetHandler", "<init>"));
        }
        super(project2, Collections.singletonList(scope), (Set<PsiFile>)new HashSet());
        this.myTargetScope = targetScope;
    }

    @Override
    protected String getProgressTitle() {
        return AnalysisScopeBundle.message((String)"package.dependencies.progress.title", (Object[])new Object[0]);
    }

    @Override
    protected String getPanelDisplayName(AnalysisScope scope) {
        return AnalysisScopeBundle.message((String)"package.dependencies.on.toolwindow.title", (Object[])new Object[]{scope.getDisplayName(), this.myTargetScope.getDisplayName()});
    }

    @Override
    protected String getPanelDisplayName(List<DependenciesBuilder> builders) {
        return this.getPanelDisplayName(AnalyzeDependenciesOnSpecifiedTargetHandler.getForwardScope(builders));
    }

    private static AnalysisScope getForwardScope(List<DependenciesBuilder> builders) {
        DependenciesBuilder builder = builders.get(0);
        return builder instanceof BackwardDependenciesBuilder ? ((BackwardDependenciesBuilder)builder).getForwardScope() : builder.getScope();
    }

    @Override
    protected boolean shouldShowDependenciesPanel(List<DependenciesBuilder> builders) {
        for (DependenciesBuilder builder : builders) {
            for (Set<PsiFile> files2 : builder.getDependencies().values()) {
                if (files2.isEmpty()) continue;
                return true;
            }
        }
        String source = StringUtil.decapitalize((String)AnalyzeDependenciesOnSpecifiedTargetHandler.getForwardScope(builders).getDisplayName());
        String target = StringUtil.decapitalize((String)this.myTargetScope.getDisplayName());
        String message2 = AnalysisScopeBundle.message((String)"no.dependencies.found.message", (Object[])new Object[]{source, target});
        if (DependencyVisitorFactory.VisitorOptions.fromSettings(this.myProject).skipImports()) {
            message2 = message2 + " ";
            message2 = message2 + AnalysisScopeBundle.message((String)"dependencies.in.imports.message", (Object[])new Object[0]);
        }
        NOTIFICATION_GROUP.createNotification(message2, MessageType.INFO).notify(this.myProject);
        return false;
    }

    @Override
    protected DependenciesBuilder createDependenciesBuilder(AnalysisScope scope) {
        return new BackwardDependenciesBuilder(this.myProject, new AnalysisScope((SearchScope)this.myTargetScope, this.myProject), scope);
    }
}

