/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.psi.PsiManager;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PackageTreeExpansionMonitor {
    private PackageTreeExpansionMonitor() {
    }

    public static TreeExpansionMonitor<PackageDependenciesNode> install(final JTree tree2, final Project project2) {
        return new TreeExpansionMonitor<PackageDependenciesNode>(tree2){

            @Override
            protected TreePath findPathByNode(PackageDependenciesNode node) {
                if (node.getPsiElement() == null) {
                    return new TreePath(node.getPath());
                }
                PsiManager manager = PsiManager.getInstance((Project)project2);
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)tree2.getModel().getRoot()).breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    PackageDependenciesNode child;
                    TreeNode nextElement = enumeration.nextElement();
                    if (!(nextElement instanceof PackageDependenciesNode) || !manager.areElementsEquivalent((child = (PackageDependenciesNode)nextElement).getPsiElement(), node.getPsiElement())) continue;
                    return new TreePath(child.getPath());
                }
                return null;
            }
        };
    }
}

