/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.Equality;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class TreeExpansionMonitor<T> {
    private final Set<TreePath> myExpandedPaths = new HashSet<TreePath>();
    private List<T> mySelectionNodes = new ArrayList<T>();
    private final JTree myTree;
    private boolean myFrozen = false;

    public static TreeExpansionMonitor<DefaultMutableTreeNode> install(JTree tree2) {
        return TreeExpansionMonitor.install(tree2, new Equality<DefaultMutableTreeNode>(){

            public boolean equals(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
                return Comparing.equal((Object)o1.getUserObject(), (Object)o2.getUserObject());
            }
        });
    }

    public static TreeExpansionMonitor<DefaultMutableTreeNode> install(final JTree tree2, final Equality<DefaultMutableTreeNode> equality) {
        return new TreeExpansionMonitor<DefaultMutableTreeNode>(tree2){

            @Override
            protected TreePath findPathByNode(DefaultMutableTreeNode node) {
                Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)tree2.getModel().getRoot()).breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode child;
                    TreeNode nextElement = enumeration.nextElement();
                    if (!(nextElement instanceof DefaultMutableTreeNode) || !equality.equals((Object)(child = (DefaultMutableTreeNode)nextElement), (Object)node)) continue;
                    return new TreePath(child.getPath());
                }
                return null;
            }
        };
    }

    protected TreeExpansionMonitor(JTree tree2) {
        this.myTree = tree2;
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e2) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreeExpansionMonitor.this.mySelectionNodes = new ArrayList();
                TreePath[] paths = TreeExpansionMonitor.this.myTree.getSelectionPaths();
                if (paths != null) {
                    for (TreePath path : paths) {
                        TreeExpansionMonitor.this.mySelectionNodes.add(path.getLastPathComponent());
                    }
                }
            }
        });
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreePath path = event.getPath();
                if (path != null) {
                    TreeExpansionMonitor.this.myExpandedPaths.add(path);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                if (TreeExpansionMonitor.this.myFrozen) {
                    return;
                }
                TreePath path = event.getPath();
                if (path != null) {
                    TreePath[] allPaths;
                    for (TreePath treePath : allPaths = TreeExpansionMonitor.this.myExpandedPaths.toArray(new TreePath[TreeExpansionMonitor.this.myExpandedPaths.size()])) {
                        if (!treePath.equals(path) && !path.isDescendant(treePath)) continue;
                        TreeExpansionMonitor.this.myExpandedPaths.remove(treePath);
                    }
                }
            }
        });
    }

    public void freeze() {
        this.myFrozen = true;
    }

    public void unfreeze() {
        this.myFrozen = false;
    }

    public void restore() {
        this.freeze();
        for (TreePath myExpandedPath : this.myExpandedPaths) {
            this.myTree.expandPath(this.findPathByNode(myExpandedPath.getLastPathComponent()));
        }
        for (TreePath mySelectionNode : this.mySelectionNodes) {
            this.myTree.getSelectionModel().addSelectionPath(this.findPathByNode(mySelectionNode));
        }
        int selected = this.myTree.getLeadSelectionRow();
        if (selected != -1) {
            TreeUtil.showRowCentered((JTree)this.myTree, (int)selected, (boolean)false);
        }
        this.myFrozen = false;
    }

    protected abstract TreePath findPathByNode(T var1);

    public boolean isFreeze() {
        return this.myFrozen;
    }
}

